CREATE TABLE FLIGHTS (
 ID					INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 PILOT_ID			INTEGER UNSIGNED NOT NULL,
 AIRLINE			CHAR(3) NOT NULL,
 FLIGHT				SMALLINT NOT NULL,
 AIRPORT_D			CHAR(3) NOT NULL,
 AIRPORT_A			CHAR(3) NOT NULL,
 AIRPORT_L			CHAR(3),
 EQTYPE				VARCHAR(15) NOT NULL,
 START_TIME			DATETIME NOT NULL,
 TAXI_TIME			DATETIME,
 TAXI_WEIGHT		INTEGER,
 TAXI_FUEL			INTEGER,
 TAKEOFF_TIME		DATETIME,
 TAKEOFF_DISTANCE	SMALLINT,
 TAKEOFF_SPEED		SMALLINT,
 TAKEOFF_N1			DECIMAL(4,1),
 TAKEOFF_HDG		SMALLINT DEFAULT -1,
 TAKEOFF_LAT		DECIMAL (7,4) NOT NULL DEFAULT 0,
 TAKEOFF_LNG		DECIMAL (7,4) NOT NULL DEFAULT 0,
 TAKEOFF_ALT		SMALLINT,
 TAKEOFF_WEIGHT		INTEGER,
 TAKEOFF_FUEL		INTEGER,
 LANDING_TIME		DATETIME,
 LANDING_DISTANCE	SMALLINT,
 LANDING_SPEED		SMALLINT,
 LANDING_N1			DECIMAL(4,1),
 LANDING_HDG		SMALLINT DEFAULT -1,
 LANDING_LAT		DECIMAL (7,4) NOT NULL DEFAULT 0,
 LANDING_LNG		DECIMAL (7,4) NOT NULL DEFAULT 0,
 LANDING_ALT		SMALLINT,
 LANDING_WEIGHT		INTEGER,
 LANDING_FUEL		INTEGER,
 END_TIME			DATETIME,
 PHASE				TINYINT UNSIGNED NOT NULL DEFAULT 0,
 CPHASE				TINYINT UNSIGNED NOT NULL DEFAULT 0,
 ZFW				INTEGER UNSIGNED,
 ROUTE				MEDIUMTEXT NOT NULL,
 FSVERSION			SMALLINT UNSIGNED NOT NULL DEFAULT 2004,
 PRIMARY KEY (ID),
 FOREIGN KEY (PILOT_ID) REFERENCES common.USERDATA(ID) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE ON DELETE CASCADE
);