CREATE TABLE CHECKRIDES (
 ID						INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 NAME               	VARCHAR(32) NOT NULL,
 PILOT_ID           	INTEGER UNSIGNED NOT NULL,
 STATUS             	SMALLINT NOT NULL DEFAULT 0,
 CREATED	         	DATETIME NOT NULL,
 SUBMITTED				DATETIME,
 GRADED		          	DATETIME,
 GRADED_BY          	INTEGER UNSIGNED,
 PASS               	BOOLEAN NOT NULL DEFAULT FALSE,
 TYPE					TINYINT UNSIGNED NOT NULL DEFAULT 0,
 EXPIRES				DATE,
 COMMENTS				TEXT CHARACTER SET utf8mb4,
 EQTYPE					VARCHAR(15) NOT NULL,
 ACTYPE					VARCHAR(15) NOT NULL,
 ACADEMY				BOOLEAN NOT NULL DEFAULT FALSE,
 OWNER					CHAR(3) NOT NULL,
 PRIMARY KEY (ID),
 FOREIGN KEY (PILOT_ID) REFERENCES common.USERDATA(ID) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE, OWNER) REFERENCES common.EQPROGRAMS(EQTYPE, OWNER) ON UPDATE CASCADE,
 FOREIGN KEY (ACTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE,
 FOREIGN KEY (OWNER) REFERENCES common.AIRLINEINFO(CODE) ON UPDATE CASCADE 
);

CREATE INDEX CRIDE_ST_IDX ON CHECKRIDES(STATUS);