CREATE TABLE AIRCRAFT (
 NAME					VARCHAR(15) NOT NULL,
 FULLNAME				VARCHAR(48) NOT NULL,
 FAMILY					VARCHAR(8) NOT NULL,
 IATA					VARCHAR(64) NOT NULL,
 ICAO					VARCHAR(4) NOT NULL DEFAULT '',
 HISTORIC				BOOLEAN NOT NULL DEFAULT FALSE,
 ACADEMY_ONLY           BOOLEAN NOT NULL DEFAULT FALSE,
 ENGINES				TINYINT UNSIGNED NOT NULL,
 ENGINE_TYPE			VARCHAR(32) NOT NULL,
 CRUISE_SPEED			SMALLINT UNSIGNED NOT NULL,
 FUEL_FLOW				SMALLINT UNSIGNED NOT NULL,
 BASE_FUEL				SMALLINT UNSIGNED NOT NULL,
 TAXI_FUEL				SMALLINT UNSIGNED NOT NULL,
 PRI_TANKS				SMALLINT UNSIGNED NOT NULL,
 PRI_PCT				TINYINT UNSIGNED NOT NULL DEFAULT 100,
 SEC_TANKS				SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 SEC_PCT				TINYINT UNSIGNED NOT NULL DEFAULT 0,
 OTHER_TANKS			SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 MAX_WEIGHT				INTEGER UNSIGNED NOT NULL DEFAULT 0,
 MAX_TWEIGHT			INTEGER UNSIGNED NOT NULL DEFAULT 0,
 MAX_LWEIGHT			INTEGER UNSIGNED NOT NULL DEFAULT 0,
 MAX_ZFW				INTEGER UNSIGNED NOT NULL DEFAULT 0,
 PRIMARY KEY (NAME),
 UNIQUE CONSTRAINT (ICAO),
);