REPLACE INTO FLIGHTSTATS_AIRPORT (SELECT AIRPORT_D, COUNT(DISTANCE) AS LEGS, SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, 
SUM(IF((ATTR & 2) > 0, 1, 0)) AS VATSIM, SUM(IF((ATTR & 4) > 0, 1, 0)) AS IVAO, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP,
SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX), 
SUM(IF(FSVERSION=2000,1,0)) AS FS7, SUM(IF(FSVERSION=2002,1,0)) AS FS8, SUM(IF(FSVERSION=2004,1,0)) AS FS9, SUM(IF(FSVERSION=2006,1,0)) AS FSX, SUM(IF(FSVERSION=2008,1,0)) AS P3D,
SUM(IF(FSVERSION=2017,1,0)) AS P3Dv4, SUM(IF(FSVERSION=100,1,IF(FSVERSION=101,1,0))) AS XP, SUM(IF(FSVERSION=102,1,0)) AS XP11, SUM(IF(FSVERSION=103,1,0)) AS XP12,
SUM(IF(FSVERSION=2020,1,0)) AS FS2020, SUM(IF(FSVERSION=2024,1,0)) AS FS2024, SUM(IF(FSVERSION=0,1,0)) AS FSO, 1 FROM PIREPS WHERE (STATUS=3) GROUP BY AIRPORT_D);

REPLACE INTO FLIGHTSTATS_AIRPORT (SELECT AIRPORT_A, COUNT(DISTANCE) AS LEGS, SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, 
SUM(IF((ATTR & 2) > 0, 1, 0)) AS VATSIM, SUM(IF((ATTR & 4) > 0, 1, 0)) AS IVAO, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP,
SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX), 
SUM(IF(FSVERSION=2000,1,0)) AS FS7, SUM(IF(FSVERSION=2002,1,0)) AS FS8, SUM(IF(FSVERSION=2004,1,0)) AS FS9, SUM(IF(FSVERSION=2006,1,0)) AS FSX, SUM(IF(FSVERSION=2008,1,0)) AS P3D,
SUM(IF(FSVERSION=2017,1,0)) AS P3Dv4, SUM(IF(FSVERSION=100,1,IF(FSVERSION=101,1,0))) AS XP, SUM(IF(FSVERSION=102,1,0)) AS XP11, SUM(IF(FSVERSION=103,1,0)) AS XP12, 
SUM(IF(FSVERSION=2020,1,0)) AS FS2020, SUM(IF(FSVERSION=2024,1,0)) AS FS2024, SUM(IF(FSVERSION=0,1,0)) AS FSO, 0 FROM PIREPS WHERE (STATUS=3) GROUP BY AIRPORT_A);

REPLACE INTO FLIGHTSTATS_PILOT (SELECT PILOT_ID, COUNT(DISTANCE) AS LEGS, SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, 
SUM(IF((ATTR & 2) > 0, 1, 0)) AS VATSIM, SUM(IF((ATTR & 4) > 0, 1, 0)) AS IVAO, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP,
SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX), 
SUM(IF(FSVERSION=2000,1,0)) AS FS7, SUM(IF(FSVERSION=2002,1,0)) AS FS8, SUM(IF(FSVERSION=2004,1,0)) AS FS9, SUM(IF(FSVERSION=2006,1,0)) AS FSX, SUM(IF(FSVERSION=2008,1,0)) AS P3D,
SUM(IF(FSVERSION=2017,1,0)) AS P3Dv4, SUM(IF(FSVERSION=100,1,IF(FSVERSION=101,1,0))) AS XP, SUM(IF(FSVERSION=102,1,0)) AS XP11, SUM(IF(FSVERSION=103,1,0)) AS XP12,
SUM(IF(FSVERSION=2020,1,0)) AS FS2020, SUM(IF(FSVERSION=2024,1,0)) AS FS2024, SUM(IF(FSVERSION=0,1,0)) AS FSO FROM PIREPS WHERE (STATUS=3) GROUP BY PILOT_ID);

REPLACE INTO FLIGHTSTATS_EQTYPE (SELECT EQTYPE, COUNT(DISTANCE) AS LEGS, SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, 
SUM(IF((ATTR & 2) > 0, 1, 0)) AS VATSIM, SUM(IF((ATTR & 4) > 0, 1, 0)) AS IVAO, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP,
SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX), 
SUM(IF(FSVERSION=2000,1,0)) AS FS7, SUM(IF(FSVERSION=2002,1,0)) AS FS8, SUM(IF(FSVERSION=2004,1,0)) AS FS9, SUM(IF(FSVERSION=2006,1,0)) AS FSX, SUM(IF(FSVERSION=2008,1,0)) AS P3D,
SUM(IF(FSVERSION=2017,1,0)) AS P3Dv4, SUM(IF(FSVERSION=100,1,IF(FSVERSION=101,1,0))) AS XP, SUM(IF(FSVERSION=102,1,0)) AS XP11, SUM(IF(FSVERSION=103,1,0)) AS XP12,
SUM(IF(FSVERSION=2020,1,0)) AS FS2020, SUM(IF(FSVERSION=2024,1,0)) AS FS2024, SUM(IF(FSVERSION=0,1,0)) AS FSO FROM PIREPS WHERE (STATUS=3) GROUP BY EQTYPE);

REPLACE INTO FLIGHTSTATS_DATE (SELECT DATE, COUNT(DISTANCE) AS LEGS, SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, 
SUM(IF((ATTR & 2) > 0, 1, 0)) AS VATSIM, SUM(IF((ATTR & 4) > 0, 1, 0)) AS IVAO, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP,
SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX), 
SUM(IF(FSVERSION=2000,1,0)) AS FS7, SUM(IF(FSVERSION=2002,1,0)) AS FS8, SUM(IF(FSVERSION=2004,1,0)) AS FS9, SUM(IF(FSVERSION=2006,1,0)) AS FSX, SUM(IF(FSVERSION=2008,1,0)) AS P3D,
SUM(IF(FSVERSION=2017,1,0)) AS P3Dv4, SUM(IF(FSVERSION=100,1,IF(FSVERSION=101,1,0))) AS XP, SUM(IF(FSVERSION=102,1,0)) AS XP11, SUM(IF(FSVERSION=103,1,0)) AS XP12,
SUM(IF(FSVERSION=2020,1,0)) AS FS2020, SUM(IF(FSVERSION=2024,1,0)) AS FS2024, SUM(IF(FSVERSION=0,1,0)) AS FSO FROM PIREPS WHERE (STATUS=3) GROUP BY DATE);

REPLACE INTO FLIGHTSTATS_NETWORK (SELECT DATE, IF((ATTR & 2) > 0, 0, IF((ATTR & 4) > 0, 1, IF((ATTR & 0x100000) > 0, 5, IF((ATTR & 0x800000) > 0, 6, -1)))) AS NET, COUNT(DISTANCE) AS LEGS,
SUM(IF((ATTR & 0x10) > 0, 1, 0)) AS ACARS, SUM(IF((ATTR & 0x200) > 0, 1, 0)) AS HIST, SUM(IF((ATTR & 0x4000) > 0, 1, 0)) AS DSP, SUM(IF((ATTR & 0x1000000) > 0, 1, 0)) AS SB, 
SUM(IF(TOUR_ID > 0, 1, 0)) AS TLEGS, SUM(DISTANCE) AS MILES, SUM(FLIGHT_TIME) AS HOURS, COUNT(DISTINCT PILOT_ID) AS PIDS, AVG(LOADFACTOR), SUM(PAX) FROM PIREPS WHERE (STATUS=3) GROUP BY DATE, NET);

REPLACE INTO FLIGHTSTATS_LANDING (SELECT PR.ID, PR.PILOT_ID, PR.EQTYPE, DATE(APR.LANDING_TIME), PR.AIRPORT_A, APR.LANDING_VSPEED, R.DISTANCE, APR.LANDING_SCORE FROM PIREPS PR, 
ACARS_PIREPS APR, acars.RWYDATA R WHERE (APR.ID=PR.ID) AND (APR.ACARS_ID=R.ID) AND (R.ISTAKEOFF=0) AND (R.DISTANCE<22500));

REPLACE INTO FLIGHTSTATS_GATE (SELECT G.ICAO, G.NAME, F.AIRLINE, F.AIRPORT_D, F.AIRPORT_A, GD.ISDEPARTURE, COUNT(GD.ID) AS CNT FROM acars.FLIGHTS F, acars.GATEDATA GD, common.GATES G 
WHERE (GD.ID=F.ID) AND (G.ICAO=GD.ICAO) AND (G.NAME=GD.GATE) AND F.CREATED>DATE_SUB(NOW(), INTERVAL 6 YEAR)  GROUP BY G.ICAO, G.NAME, F.AIRLINE, F.AIRPORT_D, F.AIRPORT_A, GD.ISDEPARTURE ORDER BY CNT, G.NAME, F.AIRLINE);
