CREATE TABLE FLIGHTSTATS_LANDING (
 ID                 INTEGER UNSIGNED NOT NULL,
 PILOT_ID           INTEGER UNSIGNED NOT NULL,
 EQTYPE             VARCHAR(15) NOT NULL,
 DATE               DATE NOT NULL,
 AIRPORT            CHAR(3) NOT NULL,
 VSPEED	            INTEGER NOT NULL,
 RWYDISTANCE        SMALLINT NOT NULL,
 SCORE              SMALLINT NOT NULL DEFAULT -1,
 PRIMARY KEY (ID),
 FOREIGN KEY (ID) REFERENCES PIREPS(ID) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (PILOT_ID) REFERENCES PILOTS(ID) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE
);

CREATE INDEX LDG_DT_IDX ON FLIGHTSTATS_LANDING(DATE);
