CREATE TABLE FLIGHTSTATS_GATE (
 ICAO                CHAR(4) NOT NULL,
 GATE                VARCHAR(16) NOT NULL,
 AIRLINE             CHAR(3) NOT NULL,
 AIRPORT_D           CHAR(3) NOT NULL,
 AIRPORT_A           CHAR(3) NOT NULL,
 ISDEPARTURE         BOOLEAN NOT NULL DEFAULT FALSE,
 USECOUNT            INTEGER UNSIGNED NOT NULL DEFAULT 0,
 PRIMARY KEY (ICAO, GATE, AIRLINE, AIRPORT_D, AIRPORT_A, ISDEPARTURE),
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE
) CHARACTER SET latin1;

CREATE INDEX FLIGHTSTATS_GATE_RP_IDX ON FLIGHTSTATS_GATE(AIRPORT_D, AIRPORT_A);