CREATE TABLE SCHEDULE (
 AIRLINE			CHAR(3) NOT NULL,
 FLIGHT				SMALLINT NOT NULL,
 LEG				SMALLINT NOT NULL,
 AIRPORT_D			CHAR(3) NOT NULL,
 AIRPORT_A			CHAR(3) NOT NULL,
 DISTANCE			SMALLINT NOT NULL,
 EQTYPE				VARCHAR(15) NOT NULL,
 FLIGHT_TIME		SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 TIME_D				TIME NOT NULL,
 TIME_A				TIME NOT NULL,
 PLUSDAYS           TINYINT UNSIGNED NOT NULL DEFAULT 0,
 HISTORIC			BOOLEAN NOT NULL DEFAULT FALSE,
 ACADEMY			BOOLEAN NOT NULL DEFAULT FALSE,
 DST_ADJUST         BOOLEAN NOT NULL DEFAULT FALSE,
 SRC                TINYINT NOT NULL DEFAULT -1,
 CODESHARE          VARCHAR(10),
 REMARKS            VARCHAR(32),
 PRIMARY KEY (AIRLINE, FLIGHT, LEG),
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE
);
 
CREATE INDEX SCHED_FN_IDX ON SCHEDULE(FLIGHT);