CREATE TABLE RAW_SCHEDULE (
 SRC                SMALLINT UNSIGNED NOT NULL,
 SRCLINE            INTEGER UNSIGNED NOT NULL,
 STARTDATE          DATE NOT NULL,
 ENDDATE            DATE NOT NULL,
 DAYS	            SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 AIRLINE            CHAR(3) NOT NULL,
 FLIGHT             SMALLINT UNSIGNED NOT NULL,
 LEG                TINYINT UNSIGNED NOT NULL DEFAULT 1,
 AIRPORT_D          CHAR(3) NOT NULL,
 AIRPORT_A          CHAR(3) NOT NULL,
 EQTYPE             VARCHAR(15) NOT NULL,
 TIME_D             DATETIME NOT NULL,
 TIME_A             DATETIME NOT NULL,
 PLUSDAYS           TINYINT UNSIGNED NOT NULL DEFAULT 0,
 FORCE_INCLUDE      BOOLEAN NOT NULL DEFAULT FALSE,
 ISUPDATED          BOOELAN NOT NULL DEFAULT FALSE,
 ACADEMY            BOOLEAN NOT NULL DEFAULT FALSE,
 CODESHARE          VARCHAR(10),
 REMARKS            VARCHAR(32),
 PRIMARY KEY (SRC, SRCLINE),
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE
) DEFAULT CHARSET=latin1;