CREATE TABLE AIRPORTS (
 IATA                   CHAR(3) NOT NULL,
 ICAO                   CHAR(4) NOT NULL,
 TZ						VARCHAR(32) NOT NULL,
 NAME					VARCHAR(48) CHARACTER SET utf8mb4 NOT NULL,
 COUNTRY				CHAR(2) NOT NULL,
 LATITUDE				DECIMAL(10,6) NOT NULL,
 LONGITUDE				DECIMAL(10,6) NOT NULL,
 ADSE					BOOLEAN NOT NULL DEFAULT FALSE,
 HAS_USPFI              BOOLEAN NOT NULL DEFAULT FALSE,
 IS_SCHENGEN            BOOLEAN NOT NULL DEFAULT FALSE,
 HAS_FICTIONAL_CODE     BOOLEAN NOT NULL DEFAULT FALSE,
 OLDCODE				CHAR(3),
 PRIMARY KEY (IATA),
 CONSTRAINT UNIQUE (NAME),
 CONSTRAINT UNIQUE (ICAO),
 FOREIGN KEY (TZ) REFERENCES TZ(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (CODE) REFERENCES COUNTRY(CODE) ON UPDATE CASCADE
) CHARACTER SET latin1;