CREATE TABLE PIREPS (
 ID					INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 PILOT_ID			INTEGER UNSIGNED NOT NULL,
 RANK				VARCHAR(24) NOT NULL DEFAULT 'First Officer',
 STATUS				SMALLINT,
 DATE				DATE NOT NULL,
 AIRLINE			CHAR(3) NOT NULL,
 FLIGHT				SMALLINT NOT NULL,
 LEG				SMALLINT NOT NULL,
 AIRPORT_D			CHAR(3) NOT NULL,
 AIRPORT_A			CHAR(3) NOT NULL,
 EQTYPE				VARCHAR(15) NOT NULL,
 FSVERSION			SMALLINT,
 ATTR				INTEGER,
 DISTANCE			SMALLINT NOT NULL,
 FLIGHT_TIME		NUMERIC(3,1),
 DISPOSAL_ID		INTEGER,
 SUBMITTED			DATETIME,
 DISPOSED			DATETIME,
 EVENT_ID			INTEGER UNSIGNED NOT NULL DEFAULT 0,
 ASSIGN_ID			INTEGER UNSIGNED NOT NULL DEFAULT 0,
 TOUR_ID            INTEGER UNSIGNED NOT NULL DEFAULT 0,
 PAX				SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 LOADFACTOR			NUMERIC(5,4) NOT NULL DEFAULT 0,
 FLIGHT_TYPE        TINYINT UNSIGNED NOT NULL DEFAULT 0,
 PRIMARY KEY (ID),
 FOREIGN KEY (PILOT_ID) REFERENCES PILOTS(ID),
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE
);

CREATE INDEX PIREP_EQ_IDX ON PIREPS(EQTYPE);
CREATE INDEX PIREP_ST_IDX ON PIREPS(STATUS);
CREATE INDEX PIREP_DT_IDX ON PIREPS(DATE);
CREATE INDEX PIREP_EV_IDX ON PIREPS(EVENT_ID);
CREATE INDEX PIREP_AS_IDX ON PIREPS(ASSIGN_ID);
CREATE INDEX PIREP_TR_IDX ON PIREPS(TOUR_ID);
CREATE INDEX PIREP_AT_IDX ON PIREPS(ATTR);
