CREATE TABLE STATUS_UPDATES (
 PILOT_ID			INTEGER UNSIGNED NOT NULL,
 CREATED			DATETIME(3) NOT NULL,
 AUTHOR_ID			INTEGER UNSIGNED NOT NULL,
 TYPE				SMALLINT NOT NULL DEFAULT 0,
 REMARKS			TEXT CHARACTER SET utf8mb4 NOT NULL,
 PRIMARY KEY (PILOT_ID, CREATED, TYPE),
 FOREIGN KEY (PILOT_ID) REFERENCES common.USERDATA(ID) ON DELETE CASCADE,
 FOREIGN KEY (AUTHOR_ID) REFERENCES common.USERDATA(ID) ON DELETE CASCADE
) ROW_FORMAT=Dynamic;

CREATE INDEX SU_TYP_IDX ON STATUS_UPDATES(TYPE);
CREATE INDEX SU_DT_IDX ON STATUS_UPDATES(CREATED DESC);