CREATE TABLE PILOTS (
 ID					INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 PILOT_ID			SMALLINT UNSIGNED DEFAULT 0,
 FIRSTNAME			VARCHAR(32) CHARACTER SET utf8mb4 NOT NULL,
 LASTNAME			VARCHAR(32) CHARACTER SET utf8mb4 NOT NULL,
 STATUS				SMALLINT,
 LDAP_DN			VARCHAR(96) CHARACTER SET utf8mb4 NOT NULL,
 EMAIL				VARCHAR(96),
 LOCATION			VARCHAR(64) CHARACTER SET utf8mb4,
 LEGACY_HOURS		DECIMAL(6,2),
 HOME_AIRPORT		CHAR(4) NOT NULL,
 EQTYPE				VARCHAR(15) DEFAULT 'CRJ-200',
 RANKING			TINYINT UNSIGNED NOT NULL DEFAULT 0,
 VATSIM_ID			VARCHAR(12),
 IVAO_ID			VARCHAR(12),
 PE_ID              VARCHAR(12),
 POSCON_ID          VARCHAR(12),
 CREATED			DATE NOT NULL,
 LOGINS				INTEGER UNSIGNED NOT NULL DEFAULT 0,
 LAST_LOGIN			DATETIME,
 LAST_LOGOFF		DATETIME,
 TZ					VARCHAR(32) DEFAULT 'US/Eastern',
 NOTIFY				SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 SHOW_EMAIL			SMALLINT,
 SHOW_WC_SIG		BOOLEAN NOT NULL DEFAULT TRUE,
 SHOW_WC_SSHOTS		BOOLEAN NOT NULL DEFAULT TRUE,
 SHOW_DEF_SIG		BOOLEAN NOT NULL DEFAULT TRUE,
 SHOW_NEW_POSTS		BOOLEAN NOT NULL DEFAULT TRUE,
 PERMANENT          BOOLEAN NOT NULL DEFAULT FALSE,
 FORGOTTEN			BOOLEAN NOT NULL DEFAULT FALSE,
 PROF_CR			BOOLEAN NOT NULL DEFAULT FALSE,
 UISCHEME			VARCHAR(32) DEFAULT 'legacy',
 NAVBAR				BOOLEAN NOT NULL DEFAULT FALSE,
 VIEWSIZE			SMALLINT UNSIGNED NOT NULL DEFAULT 60,
 LOGINHOSTNAME		VARCHAR(96),
 DFORMAT			VARCHAR(32) DEFAULT 'MM/dd/yyyy',
 TFORMAT			VARCHAR(16) DEFAULT 'HH:mm:ss',
 NFORMAT			VARCHAR(16) DEFAULT '#,##0.0',
 AIRPORTCODE		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 DISTANCEUNITS		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 WEIGHTUNITS		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 NOEXAMS			BOOLEAN NOT NULL DEFAULT FALSE,
 NOVOICE			BOOLEAN NOT NULL DEFAULT FALSE,
 NOCOOLER			BOOLEAN NOT NULL DEFAULT FALSE,
 NOTIMECOMPRESS		BOOLEAN NOT NULL DEFAULT FALSE,
 ACARS_RESTRICT		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 ACARS_UPDCH        TINYINT UNSIGNED NOT NULL DEFAULT 0,
 EMAIL_INVALID		BOOLEAN NOT NULL DEFAULT FALSE,
 UID				VARCHAR(15),
 MOTTO				VARCHAR(64) CHARACTER SET utf8mb4,
 PRIMARY KEY (ID),
 FOREIGN KEY (ID) REFERENCES common.USERDATA(ID) ON UPDATE CASCADE,
 FOREIGN KEY (TZ) REFERENCES common.TZ(CODE) ON UPDATE CASCADE
) ROW_FORMAT=Dynamic CHARACTER SET latin1;

CREATE INDEX PILOT_PID_IDX ON PILOTS(PILOT_ID);
CREATE INDEX PILOT_EQ_IDX ON PILOTS(EQTYPE);
CREATE INDEX PILOT_LN_IDX ON PILOTS(LASTNAME);
CREATE INDEX PILOT_RANK_IDX ON PILOTS(RANK);
CREATE INDEX PILOT_STATUS_IDX ON PILOTS(STATUS);
