CREATE TABLE APPLICANTS (
 ID                 INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 PILOT_ID           INTEGER UNSIGNED,
 STATUS             SMALLINT,
 FIRSTNAME          VARCHAR(32) CHARACTER SET utf8mb4 NOT NULL,
 LASTNAME           VARCHAR(32) CHARACTER SET utf8mb4 NOT NULL,
 EMAIL              VARCHAR(96) NOT NULL,
 LOCATION           VARCHAR(64) CHARACTER SET utf8mb4,
 IMHANDLE			VARCHAR(32),
 MSNHANDLE			VARCHAR(128),
 VATSIM_ID          VARCHAR(12),
 IVAO_ID            VARCHAR(12),
 PE_ID				VARCHAR(12),
 POSCON_ID          VARCHAR(12),
 LEGACY_HOURS       DECIMAL(6,1),
 LEGACY_URL         VARCHAR(192),
 LEGACY_OK          BOOLEAN NOT NULL DEFAULT FALSE,
 CAPTCHA_OK         BOOLEAN NOT NULL DEFAULT FALSE,
 AUTO_REJECT        BOOLEAN NOT NULL DEFAULT FALSE,
 HOME_AIRPORT       CHAR(3),
 EQTYPE             VARCHAR(15) DEFAULT 'CRJ-200',
 RANK               VARCHAR(24) DEFAULT 'First Officer',
 NOTIFY				SMALLINT UNSIGNED NOT NULL DEFAULT 0,
 SHOW_EMAIL			SMALLINT,
 CREATED            DATETIME,
 REGADDR			VARBINARY(16),
 REGHOSTNAME		VARCHAR(96),
 DFORMAT			VARCHAR(32) DEFAULT 'MM/dd/yyyy',
 TFORMAT			VARCHAR(16) DEFAULT 'HH:mm:ss',
 NFORMAT			VARCHAR(16) DEFAULT '#,###,##0.0',
 AIRPORTCODE		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 DISTANCEUNITS		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 WEIGHTUNITS		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 SIM_VERSION		TINYINT UNSIGNED NOT NULL DEFAULT 0,
 TZ                 VARCHAR(32) NOT NULL DEFAULT 'US/Eastern',
 UISCHEME			VARCHAR(32) NOT NULL DEFAULT 'legacy',
 COMMENTS			TEXT CHARACTER SET utf8mb4,
 HR_COMMENTS		TEXT CHARACTER SET utf8mb4,
 PRIMARY KEY (ID),
 FOREIGN KEY (ID) REFERENCES common.USERDATA(ID),
 FOREIGN KEY (TZ) REFERENCES common.TZ(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES EQTYPES(EQTYPE) ON UPDATE CASCADE
) CHARACTER SET latin1;