CREATE TABLE SIDSTAR_WAYPOINTS (
 ICAO                   CHAR(4) NOT NULL,
 TYPE                   TINYINT UNSIGNED NOT NULL DEFAULT 0,
 ID                     SMALLINT UNSIGNED NOT NULL,
 SEQ                    TINYINT UNSIGNED NOT NULL,
 WAYPOINT               VARCHAR(8) NOT NULL,
 WPTYPE                 TINYINT UNSIGNED NOT NULL DEFAULT 3,
 LATITUDE               DECIMAL (10,6) NOT NULL,
 LONGITUDE              DECIMAL (10,6) NOT NULL,
 REGION                 VARCHAR(3),
 LL                     POINT NOT NULL SRID 4326,
 PRIMARY KEY (ICAO, TYPE, ID, SEQ),
 FOREIGN KEY (ICAO, TYPE, ID) REFERENCES SIDSTAR_META(ICAO, TYPE, ID) ON UPDATE CASCADE ON DELETE CASCADE,
 CONSTRAINT SID_STAR_WP UNIQUE INDEX (ICAO, TYPE, ID, WAYPOINT)
);