CREATE TABLE EVENTS (
 ID				INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 TITLE			VARCHAR(80) CHARACTER SET utf8mb4 NOT NULL,
 STATUS			SMALLINT NOT NULL,
 NETWORK		SMALLINT,
 STARTTIME		DATETIME NOT NULL,
 ENDTIME		DATETIME NOT NULL,
 SU_DEADLINE	DATETIME NOT NULL,
 BRIEFING		MEDIUMTEXT CHARACTER SET utf8mb4,
 CAN_SIGNUP		BOOLEAN NOT NULL DEFAULT TRUE,
 SIGNUP_URL		VARCHAR(224),
 OWNER			VARCHAR(3) NOT NULL,
 PRIMARY KEY (ID),
 FOREIGN KEY (OWNER) REFERENCES REFERENCES common.AIRLINEINFO(CODE) ON UPDATE CASCADE
) ROW_FORMAT=Dynamic;

CREATE INDEX EV_STATUS_IDX ON EVENTS(STATUS);
CREATE INDEX EV_ST_IDX ON EVENTS(STARTTIME);
CREATE INDEX EV_ET_IDX ON EVENTS(ENDTIME);
