CREATE TABLE COOLER_POSTS (
 THREAD_ID                  INTEGER UNSIGNED NOT NULL,
 POST_ID                    INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 AUTHOR_ID                  INTEGER UNSIGNED NOT NULL,
 CREATED                    DATETIME NOT NULL,
 REMOTE_ADDR                VARBINARY(16),
 REMOTE_HOST                VARCHAR(128),
 MSGBODY                    MEDIUMTEXT CHARACTER SET utf8mb4 NOT NULL,
 CONTENTWARN				BOOLEAN NOT NULL DEFAULT FALSE,
 PRIMARY KEY (POST_ID, THREAD_ID),
 FOREIGN KEY (THREAD_ID) REFERENCES COOLER_THREADS(ID) ON DELETE CASCADE ON UPDATE CASCADE,
 FOREIGN KEY (AUTHOR_ID) REFERENCES USERDATA(ID)
);

CREATE INDEX COOLER_POSTS_DATE_IDX ON COOLER_POSTS(CREATED);
CREATE FULLTEXT INDEX MSGBODY_IDX ON COOLER_POSTS(MSGBODY);
