CREATE TABLE CHARTER_REQUESTS (
 ID                    INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
 AUTHOR_ID             INTEGER UNSIGNED NOT NULL,
 CREATED               DATETIME NOT NULL,
 AIRPORT_D             CHAR(3) NOT NULL,
 AIRPORT_A             CHAR(3) NOT NULL,
 AIRLINE               CHAR(3) NOT NULL,
 EQTYPE                VARCHAR(15) NOT NULL,
 DISPOSAL_ID           INTEGER UNSIGNED,
 DISPOSED              DATETIME,
 STATUS                TINYINT UNSIGNED NOT NULL DEFAULT 0,
 REMARKS               TEXT CHARACTER SET utf8mb4,
 PRIMARY KEY (ID),
 FOREIGN KEY (AUTHOR_ID) REFERENCES PILOTS(ID) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRPORT_D) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRPORT_A) REFERENCES common.AIRPORTS(IATA) ON UPDATE CASCADE ON DELETE CASCADE,
 FOREIGN KEY (AIRLINE) REFERENCES common.AIRLINES(CODE) ON UPDATE CASCADE,
 FOREIGN KEY (EQTYPE) REFERENCES common.AIRCRAFT(NAME) ON UPDATE CASCADE
) ROW_FORMAT=Dynamic CHARACTER SET latin1;