<!DOCTYPE html>
<%@ page contentType="text/html; charset=UTF-8" session="false" trimDirectiveWhitespaces="true" %>
<%@ taglib uri="/WEB-INF/dva_content.tld" prefix="content" %>
<%@ taglib uri="/WEB-INF/dva_html.tld" prefix="el" %>
<%@ taglib uri="/WEB-INF/dva_format.tld" prefix="fmt" %>
<html lang="en">
<head>
<title><content:airline /> Oceanic Route <fmt:date fmt="d" date="${route.date}" /></title>
<content:css name="main" />
<content:css name="form" />
<content:pics />
<content:favicon />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<content:js name="common" />
</head>
<content:copyright visible="false" />
<body>
<content:page>
<%@ include file="/jsp/main/header.jspf" %> 
<%@ include file="/jsp/main/sideMenu.jspf" %>

<!-- Main Body Frame -->
<content:region id="main">
<el:table className="form">
<tr class="title caps">
 <td colspan="2">${route.type} ROUTES FOR <fmt:date fmt="d" date="${route.date}" /></td>
</tr>
<tr>
 <td class="label">Source</td>
 <td class="data">${route.source}</td>
</tr>
<c:if test="${!empty route.fetchDate}">
<tr>
 <td class="label">Retrieved on</td>
 <td class="data"><fmt:date date="${route.fetchDate}" /></td>
</tr>
</c:if>
<tr>
 <td colspan="2" class="left">${route.route}</td>
</tr>
<tr>
 <td colspan="2">&nbsp;</td>
</tr>
</el:table>
</content:region>
</content:page>
<content:googleAnalytics />
</body>
</html>
