<!DOCTYPE html>
<%@ page contentType="text/html; charset=UTF-8" session="false" trimDirectiveWhitespaces="true" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/dva_content.tld" prefix="content" %>
<%@ taglib uri="/WEB-INF/dva_html.tld" prefix="el" %>
<%@ taglib uri="/WEB-INF/dva_format.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/dva_mapbox.tld" prefix="map" %>
<html lang="en">
<head>
<title><content:airline /> ACARS Flight Data - Flight <fmt:int value="${info.ID}" /></title>
<content:expire expires="30" />
<content:css name="main" />
<content:css name="form" />
<content:css name="view" />
<content:pics />
<content:favicon />
<content:js name="common" />
<c:if test="${mapRoute.size() > 0}"><map:api version="3" />
<content:js name="acarsFlightMap" />
<content:js name="threebox" /></c:if>
<content:googleAnalytics />
<content:cspHeader />
</head>
<content:copyright visible="false" />
<body onunload="void golgotha.maps.util.unload()">
<content:page>
<%@ include file="/jsp/main/header.jspf" %> 
<%@ include file="/jsp/main/sideMenu.jspf" %>

<!-- Main Body Frame -->
<content:region id="main">
<el:form action="acarsinfo.do" method="post" validate="return false">
<el:table className="form">
<tr class="title caps">
 <td colspan="4">ACARS FLIGHT INFORMATION - FLIGHT #<fmt:int value="${info.ID}" /></td>
</tr>
<tr>
 <td class="label">Pilot Name</td>
 <td class="data">${pilot.rank.name}&nbsp;<span class="pri bld">${pilot.name}</span> <span class="sec">(${pilot.pilotCode})</span></td>
 <td class="label">ACARS Client Build</td>
 <td class="data">Build <fmt:int value="${info.clientBuild}" /><c:if test="${info.getBeta() > 0}"> (Beta ${info.getBeta()})</c:if></td>
</tr>
<tr>
 <td class="label">Remote Address</td>
 <td class="data" colspan="3">${info.remoteAddr} (${info.remoteHost})</td>
</tr>
<tr>
 <td class="label">Equipment Type</td>
 <td class="data">${info.equipmentType}&nbsp;<span class="sec">(using ${info.simulator.name}<c:if test="${info.simMajor > 1}"> <content:simVersion sim="${info.simulator}" major ="${info.simMajor}" minor="${info.simMinor}" /></c:if>)</span></td>
 <td class="label">Flight Code</td>
 <td class="data pri bld">${info.flightCode}</td>
</tr>
<tr>
 <td class="label">Flight from</td>
 <td class="data">${info.airportD.name} (<el:cmd url="airportinfo" linkID="${info.airportD.IATA}" className="plain"><fmt:airport airport="${info.airportD}" /></el:cmd>)</td>
 <td class="label">Flight to</td>
 <td class="data">${info.airportA.name} (<el:cmd url="airportinfo" linkID="${info.airportA.IATA}" className="plain"><fmt:airport airport="${info.airportA}" /></el:cmd>)</td>
</tr>
<tr>
 <td class="label">Flight started at</td>
 <td class="data"><fmt:date date="${info.startTime}" /></td>
 <td class="label">Flight ended at</td>
 <td class="data"><fmt:date date="${info.endTime}" /></td>
</tr>
<tr>
 <td class="label">Filed Route</td>
 <td class="data" colspan="3">${info.route}</td>
</tr>
<tr>
 <td class="label">Pilot Remarks</td>
 <td class="data" colspan="3">${info.remarks}</td>
</tr>
<c:if test="${(!empty dispatcher) || (!empty route)}">
<c:set var="cspan" value="${(!empty dispatcher) && (!empty route) ? 1 : 3}" scope="page" />
<!-- ACARS Dispatch Information -->
<tr class="title caps">
 <td colspan="4">ACARS DISPATCH DATA</td>
</tr>
<c:if test="${!empty dispatcher}">
<tr>
 <td class="label">Dispatcher</td>
 <td class="data" colspan="${cspan}">${dispatcher.name} <span class="pri bld">(${dispatcher.pilotCode})</span></td>
</tr>
</c:if>
<c:if test="${!empty route}">
 <td class="label">Route</td>
 <td class="data" colspan="${cspan}"><fmt:int value="${route.ID}" />, used <fmt:int value="${route.useCount}" /> times</td>
</c:if>
</c:if>
<c:if test="${!empty pirep}">
<!-- ACARS PIREP data -->
<c:set var="cspan" value="3" scope="page" />
<c:set var="flightInfo" value="${info}" scope="page" />
<%@include file="/jsp/pilot/pirepACARS.jspf" %>
<c:if test="${!empty pirep.remarks}">
<tr>
 <td class="label top">Comments</td>
 <td class="data" colspan="3"><fmt:text value="${pirep.remarks}" /></td>
</tr>
</c:if>
</c:if>

<c:if test="${mapRoute.size() > 0}">
<!-- Flight Map -->
<tr>
 <td class="label">Route Map Data</td>
 <td class="data" colspan="4"><span class="bld"><el:box name="showRoute" idx="*" onChange="void map.toggle(golgotha.maps.acarsFlight.gRoute, this.checked)" label="Route" checked="false" />
<el:box name="showFDR" idx="*" onChange="void map.toggle(golgotha.maps.acarsFlight.routeMarkers, this.checked)" label="Flight Data" checked="false" /> 
<el:box name="showFPlan" idx="*" onChange="void map.toggle(golgotha.maps.acarsFlight.gfRoute, this.checked)" label="Flight Plan" checked="true" /> 
<el:box name="showAirspace" idx="*" onChange="void golgotha.maps.acarsFlight.toggleAirspace(this.checked)" label="Airspace Boundaries" checked="false" />
<el:box name="showFPMarkers" idx="*" onChange="void map.toggle(golgotha.maps.acarsFlight.filedMarkers, this.checked)" label="Navaid Markers" checked="true" /></span>
<span id="routeProgress" class="small"></span></td>
</tr>
<tr>
 <td class="data" colspan="5"><map:div ID="googleMap" height="530" /></td>
</tr>
</c:if>
</el:table>

<!-- Button Bar -->
<content:filter roles="Admin"><c:if test="${empty pirep}">
<el:table className="bar">
<tr>
 <td><el:cmdbutton url="acarsdelf" link="${info}" label="DELETE FLIGHT INFORMATION ENTRY" /></td>
</tr>
</el:table>
</c:if></content:filter>
</el:form>
<br />
<content:copyright />
</content:region>
</content:page>
<c:if test="${mapRoute.size() > 0}">
<script async>
<map:token />

// Build the route line and map center
<map:point var="golgotha.local.mapC" point="${mapCenter}" />
<map:bounds var="golgotha.local.bb" items="${info.airports}" />
<map:points var="golgotha.maps.acarsFlight.filedPoints" items="${filedRoute}" />
<map:markers var="golgotha.maps.acarsFlight.filedMarkers" items="${filedRoute}" />
<map:line var="golgotha.maps.acarsFlight.gfRoute" src="golgotha.maps.acarsFlight.filedPoints" color="#a0400f" width="2" transparency="0.7" />

// Build the map
const map = new golgotha.maps.Map(document.getElementById('googleMap'), {center:golgotha.local.mapC, minZoom:2, maxZoom:15, bounds:golgotha.local.bb, projection:'globe', fitBoundsOptions:{padding:48}, scrollZoom:false, style:'mapbox://styles/mapbox/outdoors-v12'});
window.tb = new Threebox(map, map.getCanvas().getContext('webgl'), {defaultLights:true});
map.addControl(new mapboxgl.FullscreenControl(), 'top-right');
map.addControl(new mapboxgl.NavigationControl(), 'top-right');
map.on('style.load', golgotha.maps.updateMapText);
map.once('load', function() {
	map.addControl(new golgotha.maps.BaseMapControl(golgotha.maps.DEFAULT_TYPES), 'top-left');
	golgotha.maps.acarsFlight.getACARSData(${info.ID});
	map.addLine(golgotha.maps.acarsFlight.gfRoute);
	map.addMarkers(golgotha.maps.acarsFlight.filedMarkers);
});
</script></c:if>
</body>
</html>
