package com.feldt.metar;
import com.feldt.metar.Wind;

import junit.framework.TestCase;

/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * WindTest.java
 * 
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.1, 01/20/2005
 */
public class WindTest extends TestCase {

	public void testisAWind() {
		// not enough characters
		assertFalse(Wind.isAWind(null));
		assertFalse(Wind.isAWind("000"));
		
		// properly formatted VRB
		assertFalse(Wind.isAWind("VXB0000"));
		assertFalse(Wind.isAWind("VRX0000"));
		assertTrue(Wind.isAWind("VRB00KT"));
		
		// one of the first five characters not a digit
		assertFalse(Wind.isAWind("A000000"));
		assertFalse(Wind.isAWind("0A00000"));
		assertFalse(Wind.isAWind("00A0000"));
		assertFalse(Wind.isAWind("000A000"));
		assertFalse(Wind.isAWind("0000A00"));
		
		// sixth or seventh character can be a G, provided 2 or 3 digits follow
		assertFalse(Wind.isAWind("00000GX00KT"));
		assertTrue(Wind.isAWind("00000G00KT"));
		assertTrue(Wind.isAWind("000000G000KT"));
		
		// missing and improperly formatted last two characters
		assertFalse(Wind.isAWind("VRB000KT0"));
		assertFalse(Wind.isAWind("VRB000KX"));
	}
	
	public void testIsVariable() {
		// not enough characters
		assertFalse(Wind.isVariable("000"));
		
		// one of the first three or last three character not a digit
		assertFalse(Wind.isVariable("X00V000"));
		assertFalse(Wind.isVariable("0X0V000"));
		assertFalse(Wind.isVariable("00XV000"));
		assertFalse(Wind.isVariable("000VX00"));
		assertFalse(Wind.isVariable("000V0X0"));
		assertFalse(Wind.isVariable("000V00X"));
		
		// fourth character not V
		assertFalse(Wind.isVariable("000X000"));
		
		// working version
		assertTrue(Wind.isVariable("000V000"));
	}
}