/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * TemperatureTest.java
 *
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.1, 01/21/2005
 */

package com.feldt.metar;

import junit.framework.TestCase;


public class TemperatureTest extends TestCase {
	
	public void testisATemperature() {
		// not enough chars
		assertFalse(Temperature.isATemperature(null));
		assertFalse(Temperature.isATemperature("00"));
		
		// chars where digits expected
		assertFalse(Temperature.isATemperature("X0/00"));
		assertFalse(Temperature.isATemperature("0X/00"));
		assertFalse(Temperature.isATemperature("00/X0"));
		assertFalse(Temperature.isATemperature("00/0X"));
		assertFalse(Temperature.isATemperature("00X00"));
		
		assertTrue(Temperature.isATemperature("00/00"));
		assertTrue(Temperature.isATemperature("M00/00"));
		assertTrue(Temperature.isATemperature("M00/M00"));
	}

	public void testParseTemperature() {
		Temperature temperature = Temperature.parseTemperature("00/00");
		Integer temp = new Integer(0);
		Integer dewp = new Integer(0);
		
		assertEquals(temp, temperature.getTemperature());
		assertEquals(dewp, temperature.getDewPoint());
		
		temperature = Temperature.parseTemperature("M05/M10");
		temp = new Integer(-5);
		dewp = new Integer(-10);
		
		assertEquals(temp, temperature.getTemperature());
		assertEquals(dewp, temperature.getDewPoint());
	}
}
