/*
 * Copyright (c) 2001 Matthew Feldt. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided the copyright notice above is
 * retained.
 *
 * THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESSED OR
 * IMPLIED WARRANTIES.
 */

/**
 * CloudTest.java
 *
 * @author Matthew Feldt <developer@feldt.com>
 * @version 0.1 01/21/2005
 */


package com.feldt.metar;

import junit.framework.TestCase;


public class CloudTest extends TestCase {

	public void testisACloud() {
		
		assertFalse(Cloud.isACloud(null));
		assertFalse(Cloud.isACloud("X"));
		assertFalse(Cloud.isACloud("VV"));
		assertFalse(Cloud.isACloud("VV0"));
		assertFalse(Cloud.isACloud("VV00"));
		assertFalse(Cloud.isACloud("VVX00"));
		assertFalse(Cloud.isACloud("VV0X0"));
		assertFalse(Cloud.isACloud("VV00X"));
		assertFalse(Cloud.isACloud("VV000CBX"));
		
		assertTrue(Cloud.isACloud("SKC"));
		assertTrue(Cloud.isACloud("CLR"));
		assertTrue(Cloud.isACloud("FEW000"));
		assertTrue(Cloud.isACloud("SCT000"));
		assertTrue(Cloud.isACloud("OVC000TCU"));
		assertTrue(Cloud.isACloud("FEW000CB"));
	}
	
	public void testParseCloud() {
//		Cloud cloud = Cloud.parseCloud(null);
		
		Cloud cloud = Cloud.parseCloud("VV250CB");
		String amount = "VV";
		Integer height = new Integer(250);
		String type = "CB";
		assertEquals(amount, cloud.getAmount());
		assertEquals(height, cloud.getHeight());
		assertEquals(type, cloud.getType());
		
		cloud = Cloud.parseCloud("FEW325");
		amount = "FEW";
		height = new Integer(325);
		type = "";
		assertEquals(amount, cloud.getAmount());
		assertEquals(height, cloud.getHeight());
		assertNull(cloud.getType());
	}
}
