/*
 * Decompiled with CFR 0.152.
 */
package org.hansel.stack;

import org.hansel.stack.AndAndOp;
import org.hansel.stack.BinaryOperatorEntry;
import org.hansel.stack.HanselValue;
import org.hansel.stack.NotOp;

public class OrOrOp
extends BinaryOperatorEntry {
    private static final Compressor[] COMPRESSORS = new Compressor[]{new OrOrCompressor(), new AndCompressor(), new NotCompressor()};

    public OrOrOp(HanselValue op1, HanselValue op2) {
        super("||", 11, op1, op2);
    }

    public HanselValue compress() {
        HanselValue result = this;
        int i = 0;
        while (i < COMPRESSORS.length && result instanceof OrOrOp) {
            HanselValue op1 = result.getOperator1().compress();
            HanselValue op2 = result.getOperator2().compress();
            HanselValue newResult = null;
            if (COMPRESSORS[i].canApply(op1, op2)) {
                newResult = COMPRESSORS[i].compress(op1, op2);
                if (((HanselValue)result).toString().length() < newResult.toString().length()) {
                    result = newResult;
                }
            } else if (COMPRESSORS[i].canApply(op2, op1)) {
                newResult = COMPRESSORS[i].compress(op2, op1);
                if (((HanselValue)result).toString().length() < newResult.toString().length()) {
                    result = newResult;
                }
            }
            if (newResult != null && ((HanselValue)result).toString().length() > newResult.toString().length()) {
                result = newResult;
                i = 0;
                continue;
            }
            ++i;
        }
        return result;
    }

    public static class NotCompressor
    implements Compressor {
        public boolean canApply(HanselValue op1, HanselValue op2) {
            return op1 instanceof NotOp && op2 instanceof NotOp;
        }

        public HanselValue compress(HanselValue op1, HanselValue op2) {
            return new NotOp(new AndAndOp(op1.invert(), op2.invert()));
        }
    }

    public static class AndCompressor
    implements Compressor {
        public boolean canApply(HanselValue op1, HanselValue op2) {
            return op1 instanceof AndAndOp && op2 instanceof AndAndOp;
        }

        public HanselValue compress(HanselValue op1, HanselValue op2) {
            AndAndOp and1 = (AndAndOp)op1;
            AndAndOp and2 = (AndAndOp)op2;
            String term = and2.getOperator1().toString();
            HanselValue eliminated = this.eliminate(and1, term);
            if (eliminated != null) {
                return new AndAndOp(and2.getOperator1(), new OrOrOp(eliminated, and2.getOperator2()).compress());
            }
            return new OrOrOp(op1, op2);
        }

        private HanselValue eliminate(AndAndOp and, String term) {
            HanselValue eliminated;
            HanselValue op1 = and.getOperator1();
            if (op1.toString().equals(term)) {
                return and.getOperator2();
            }
            if (op1 instanceof AndAndOp && (eliminated = this.eliminate((AndAndOp)op1, term)) != null) {
                return new AndAndOp(eliminated, and.getOperator2());
            }
            return null;
        }
    }

    public static class OrOrCompressor
    implements Compressor {
        public boolean canApply(HanselValue op1, HanselValue op2) {
            if (!(op1 instanceof AndAndOp)) {
                return false;
            }
            HanselValue op11 = ((AndAndOp)op1).getOperator1();
            String searchFor = op2.invert().toString();
            while (op11 != null) {
                if (op11.toString().equals(searchFor)) {
                    return true;
                }
                if (op11 instanceof AndAndOp) {
                    op11 = ((AndAndOp)op11).getOperator1();
                    continue;
                }
                op11 = null;
            }
            return false;
        }

        public HanselValue compress(HanselValue op1, HanselValue op2) {
            String searchFor = op2.invert().toString();
            HanselValue remainder = ((AndAndOp)op1).getOperator2();
            HanselValue extract = ((AndAndOp)op1).getOperator1();
            while (!extract.toString().equals(searchFor)) {
                remainder = new AndAndOp(((AndAndOp)extract).getOperator2(), remainder);
                extract = ((AndAndOp)extract).getOperator1();
            }
            return new OrOrOp(op2, remainder);
        }
    }

    private static interface Compressor {
        public boolean canApply(HanselValue var1, HanselValue var2);

        public HanselValue compress(HanselValue var1, HanselValue var2);
    }
}

