/*
 * Decompiled with CFR 0.152.
 */
package org.hansel.stack;

import org.hansel.stack.NotOp;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.Value;

public class HanselValue
implements Value {
    public static final HanselValue ZERO_1 = new HanselValue("0", false, 1);
    public static final HanselValue ZERO_2 = new HanselValue("0", false, 2);
    public static final HanselValue ONE_1 = new HanselValue("1", false, 1);
    public static final HanselValue ONE_2 = new HanselValue("1", false, 2);
    public static final HanselValue NULL = new HanselValue("null", false, 1);
    public static final HanselValue DONT_CARE = new HanselValue("unknown", false, 1);
    private String value;
    private boolean booleanType;
    private int size;

    public HanselValue(String value, boolean booleanType, int size) {
        this.value = value;
        this.booleanType = booleanType;
        this.size = size;
    }

    public boolean isBoolType() {
        return this.booleanType;
    }

    public boolean equals(Value obj) {
        return this.value.equals(((HanselValue)obj).value);
    }

    public int getSize() {
        return this.size;
    }

    public HanselValue invert() {
        return new NotOp(this);
    }

    public HanselValue compress() {
        return this;
    }

    public String toString() {
        return this.value;
    }

    public String toString(Type requiredType) {
        String result = this.toString();
        if (requiredType == Type.BOOLEAN_TYPE) {
            if ("0".equals(this.value)) {
                return "false";
            }
            if ("1".equals(this.value)) {
                return "true";
            }
        }
        return result;
    }
}

