/*
 * Decompiled with CFR 0.152.
 */
package org.hansel.probes;

import org.hansel.Probe;
import org.hansel.ProbeData;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SelectProbe
extends Probe {
    private boolean[] covered;
    private int[] keys;
    private Label[] labels;
    private boolean[] isDefault;
    private boolean defaultCovered;
    private boolean isHit;

    public SelectProbe(ProbeData pd, int min, int max, Label dflt, Label[] labels) {
        super(pd);
        int i;
        this.labels = labels;
        this.keys = new int[max - min + 1];
        for (i = 0; i < max - min + 1; ++i) {
            this.keys[i] = min + i;
        }
        this.covered = new boolean[labels.length];
        this.isDefault = new boolean[labels.length];
        for (i = 0; i < this.isDefault.length; ++i) {
            this.isDefault[i] = labels[i] == dflt;
            this.covered[i] = this.isDefault[i];
        }
    }

    public SelectProbe(ProbeData pd, Label dflt, int[] keys, Label[] labels) {
        super(pd);
        this.labels = labels;
        this.keys = keys;
        this.covered = new boolean[labels.length];
        this.isDefault = new boolean[labels.length];
        for (int i = 0; i < this.isDefault.length; ++i) {
            this.isDefault[i] = labels[i] == dflt;
            this.covered[i] = this.isDefault[i];
        }
    }

    public String getFailureMessage() {
        int index;
        int count = 0;
        String cases = "";
        for (int i = 0; i < this.covered.length; ++i) {
            if (this.covered[i]) continue;
            cases = cases + "'" + this.keys[i] + "', ";
            ++count;
        }
        if (!this.defaultCovered) {
            ++count;
            cases = cases + "'default', ";
        }
        if ((index = (cases = cases.substring(0, cases.length() - 2)).lastIndexOf(44)) > -1) {
            cases = cases.substring(0, index) + " and " + cases.substring(index + 2);
        }
        if (count > 1) {
            return "Switch-cases " + cases + " have not been covered.";
        }
        return "Switch-case " + cases + " has not been covered.";
    }

    public boolean displayFailure() {
        if (!this.isHit) {
            return false;
        }
        return this.coverageFailure();
    }

    public boolean coverageFailure() {
        if (!this.defaultCovered) {
            return true;
        }
        for (int i = 0; i < this.covered.length; ++i) {
            if (this.covered[i]) continue;
            return true;
        }
        return false;
    }

    private final int getIndex(int value) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == value) {
                return i;
            }
            if (this.keys[i] <= value) continue;
            return -1;
        }
        return -1;
    }

    public void hit(int value) {
        this.isHit = true;
        int index = this.getIndex(value);
        if (index == -1 || this.isDefault[index]) {
            this.defaultCovered = true;
        } else {
            Label label = this.labels[index];
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != label) continue;
                this.covered[i] = true;
            }
        }
    }

    public void insertProbeCode(MethodVisitor cv) {
        cv.visitInsn(89);
        cv.visitLdcInsn((Object)new Integer(this.getID()));
        cv.visitMethodInsn(184, HIT_CLASS, "hitSelect", "(II)V");
    }
}

