/*
 * Decompiled with CFR 0.152.
 */
package org.hansel.probes;

import org.hansel.Probe;
import org.hansel.ProbeData;
import org.hansel.stack.HanselValue;

public abstract class BranchProbe
extends Probe {
    private boolean coverTrue;
    private boolean coverFalse;
    private HanselValue value;

    public BranchProbe(ProbeData pd, HanselValue value) {
        super(pd);
        this.value = value;
        this.coverTrue = false;
        this.coverFalse = false;
    }

    public String getFailureMessage() {
        String expression = this.coverTrue ? this.value.invert().toString() : this.value.toString();
        String result = "Branch not completely covered. Condition '" + expression + "' is not fulfilled.";
        return result;
    }

    protected void cover(boolean condition) {
        if (condition) {
            this.coverTrue = true;
        } else {
            this.coverFalse = true;
        }
    }

    public boolean displayFailure() {
        return this.coverTrue ^ this.coverFalse;
    }

    public boolean coverageFailure() {
        return !(this.coverTrue & this.coverFalse);
    }
}

