/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.hansel.TransformingAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
implements ClassFileTransformer {
    private Set<String> classNames;
    private List<ClassEntry> redefinedClasses = new Vector<ClassEntry>();

    public Transformer(Set<String> classNames) {
        this.classNames = classNames;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.classNames.contains(className.replace('/', '.'))) {
            return null;
        }
        try {
            ClassReader cr = new ClassReader((InputStream)new ByteArrayInputStream(classfileBuffer));
            ClassWriter cw = new ClassWriter(3);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            TransformingAdapter ta = new TransformingAdapter((ClassVisitor)cw, cn, loader);
            cn.accept((ClassVisitor)ta);
            this.redefinedClasses.add(new ClassEntry(className, loader, classfileBuffer));
            byte[] result = cw.toByteArray();
            if (cn.name.endsWith("Example")) {
                FileOutputStream out = new FileOutputStream("test.class");
                out.write(result);
                out.close();
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalClassFormatException(e.getMessage());
        }
    }

    public void undo(Instrumentation instrumentation) throws ClassNotFoundException, UnmodifiableClassException {
        ClassDefinition[] oldClasses = new ClassDefinition[this.redefinedClasses.size()];
        for (int i = 0; i < oldClasses.length; ++i) {
            oldClasses[i] = this.redefinedClasses.get(i).toClassDefinition();
        }
        instrumentation.redefineClasses(oldClasses);
    }

    private static class ClassEntry {
        private ClassLoader cl;
        private byte[] classBuffer;
        private String classname;

        public ClassEntry(String classname, ClassLoader cl, byte[] classBuffer) {
            this.cl = cl;
            this.classname = classname;
            this.classBuffer = classBuffer;
        }

        public ClassDefinition toClassDefinition() throws ClassNotFoundException {
            return new ClassDefinition(this.cl.loadClass(this.classname.replace('/', '.')), this.classBuffer);
        }
    }
}

