/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hansel.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Startup {
    private static Instrumentation instrumentation;
    private static Transformer transformer;
    private static Map<ClassKey, byte[]> map;

    public static void premain(String options, Instrumentation instrumentation) {
        Startup.instrumentation = instrumentation;
        new ClassKey(null, null);
        instrumentation.addTransformer(new ClassBufferCache());
    }

    private static void delegate(HashSet<String> classNames) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(Startup.class.getName());
            Method m = clazz.getMethod("init", HashSet.class);
            m.invoke(null, classNames);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void init(HashSet<String> classNames) throws IOException, IllegalClassFormatException, ClassNotFoundException, UnmodifiableClassException {
        if (Startup.class.getClassLoader() != ClassLoader.getSystemClassLoader()) {
            Startup.delegate(classNames);
            return;
        }
        if (instrumentation == null) {
            throw new IllegalStateException("Instrumentation has not been initialized. Please invoke VM with commandline option:  -javaagent hansel.jar");
        }
        Class[] allClasses = instrumentation.getAllLoadedClasses();
        transformer = new Transformer(classNames);
        instrumentation.addTransformer(transformer);
        ArrayList<ClassDefinition> redefine = new ArrayList<ClassDefinition>();
        for (int i = 0; i < allClasses.length; ++i) {
            String className = allClasses[i].getName();
            if (!classNames.contains(className)) continue;
            byte[] classfileBuffer = map.get(new ClassKey(allClasses[i].getName().replace('.', '/'), allClasses[i].getClassLoader()));
            if (classfileBuffer == null) {
                System.out.println("Skipping: " + allClasses[i].getName());
                new Exception().printStackTrace();
                continue;
            }
            redefine.add(new ClassDefinition(allClasses[i], classfileBuffer));
        }
        instrumentation.redefineClasses(redefine.toArray(new ClassDefinition[redefine.size()]));
    }

    public static void tearDown() throws ClassNotFoundException, UnmodifiableClassException {
        instrumentation.removeTransformer(transformer);
        transformer.undo(instrumentation);
        transformer = null;
    }

    static {
        map = new HashMap<ClassKey, byte[]>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassBufferCache
    implements ClassFileTransformer {
        private ClassBufferCache() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            map.put(new ClassKey(className, loader), classfileBuffer);
            return null;
        }
    }

    private static class ClassKey {
        private String classname;
        private ClassLoader cl;

        public ClassKey(String classname, ClassLoader cl) {
            this.cl = cl;
            this.classname = classname;
        }

        public boolean equals(Object obj) {
            ClassKey ck = (ClassKey)obj;
            return this.classname.equals(ck.classname) && this.cl.equals(ck.cl);
        }

        public int hashCode() {
            int hashCode = this.classname.hashCode();
            if (this.cl != null) {
                hashCode += this.cl.toString().hashCode();
            }
            return hashCode;
        }

        public String toString() {
            return this.classname + "-" + this.cl + "-" + this.hashCode();
        }
    }
}

