/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import org.hansel.ProbeTable;

public class ProbeTableClassLoader
extends ClassLoader {
    private Class probeTable = this.createClass(ProbeTable.class.getName());

    public ProbeTableClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (ProbeTable.class.getName().equals(name)) {
            return this.probeTable;
        }
        return super.loadClass(name);
    }

    public Class getProbeTable() {
        return this.probeTable;
    }

    private byte[] ressourceToByteArray(String ressourceName, String classname) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(ressourceName);
        if (is == null) {
            throw new MissingResourceException("Cannot find " + classname + ".", ProbeTable.class.getName(), ressourceName);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int count = is.read(data);
            while (count != -1) {
                baos.write(data, 0, count);
                count = is.read(data);
            }
        }
        catch (IOException e) {
            throw new MissingResourceException("Cannot read class" + e.getMessage(), classname, ressourceName);
        }
        return baos.toByteArray();
    }

    private Class createClass(String classname) {
        String ressourceName = classname.replace('.', '/') + ".class";
        byte[] classdata = this.ressourceToByteArray(ressourceName, classname);
        return this.defineClass(classname, classdata, 0, classdata.length);
    }
}

