/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.hansel.Probe;
import org.hansel.ProbeData;
import org.hansel.probes.ACmpBranchProbe;
import org.hansel.probes.BinaryBranchProbe;
import org.hansel.probes.MethodProbe;
import org.hansel.probes.NullCmpBranchProbe;
import org.hansel.probes.ProbeFilter;
import org.hansel.probes.SelectProbe;
import org.hansel.probes.UnaryBranchProbe;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class ProbeTable
extends TestSuite {
    private static ProbeTable table;
    private List<Probe> probes = new Vector<Probe>();
    private Map<ProbeData, Probe> probeMap = new HashMap<ProbeData, Probe>();
    private boolean displayStatistics = false;
    private ProbeFilter probeFilter;

    public ProbeTable(ProbeFilter probeFilter) {
        super("Coverage Test");
        this.probeFilter = probeFilter;
    }

    public void setDisplayStatistics(boolean display) {
        this.displayStatistics = display;
    }

    public int addProbe(Probe probe) {
        if (this.probeMap.containsKey(probe.getProbeData())) {
            throw new IllegalStateException("Duplicate probe.");
        }
        this.probes.add(probe);
        this.probeMap.put(probe.getProbeData(), probe);
        if (this.probeFilter == null || !this.probeFilter.filter(probe.getProbeData())) {
            this.addTest(probe);
        }
        return this.probes.size() - 1;
    }

    public Probe getCached(ProbeData pd) {
        return this.probeMap.get(pd);
    }

    public void hit(int index) {
        ((MethodProbe)this.getProbe(index)).hit();
    }

    public static void hitMethod(int index) {
        ProbeTable.getProbeTable().hit(index);
    }

    public void hitB(int condition, int index) {
        ((UnaryBranchProbe)this.getProbe(index)).hit(condition);
    }

    public static void hitBranch(int condition, int index) {
        ProbeTable.getProbeTable().hitB(condition, index);
    }

    public void hit(int n, int m, int index) {
        ((BinaryBranchProbe)this.getProbe(index)).hit(n, m);
    }

    public static void hitBranch(int n, int m, int index) {
        ProbeTable.getProbeTable().hit(n, m, index);
    }

    public void hit(Object obj1, Object obj2, int index) {
        ((ACmpBranchProbe)this.getProbe(index)).hit(obj1, obj2);
    }

    public static void hitBranch(Object obj1, Object obj2, int index) {
        ProbeTable.getProbeTable().hit(obj1, obj2, index);
    }

    public void hit(Object obj, int index) {
        ((NullCmpBranchProbe)this.getProbe(index)).hit(obj);
    }

    public static void hitBranch(Object obj, int index) {
        ProbeTable.getProbeTable().hit(obj, index);
    }

    public void hit(int value, int index) {
        ((SelectProbe)this.getProbe(index)).hit(value);
    }

    public static void hitSelect(int value, int index) {
        ProbeTable.getProbeTable().hit(value, index);
    }

    public int getProbeIndex() {
        return this.probes.size();
    }

    private Probe getProbe(int index) {
        return this.probes.get(index);
    }

    public void run(TestResult result) {
        if (result.errorCount() == 0 && result.failureCount() == 0) {
            super.run(result);
            int covered = this.getCovered();
            int count = this.getSize();
            if (this.displayStatistics && covered != count) {
                String msg = "Coverage Test failed: Only " + covered + " of " + count + " probes covered.";
                result.addFailure((Test)this, new AssertionFailedError(msg));
            }
        } else {
            result.startTest((Test)this);
            String msg = "Coverage Failure: No coverage test performed, because test failed.";
            result.addFailure((Test)this, new AssertionFailedError(msg));
            result.endTest((Test)this);
        }
        this.clear();
    }

    public void addProbeDescriptions(Description coverageDesc) throws ClassNotFoundException {
        for (Probe probe : this.probes) {
            coverageDesc.addChild(probe.getDescription());
        }
    }

    public void run(RunNotifier result, Description coverageDescription, boolean hasErrors) throws ClassNotFoundException {
        if (!hasErrors) {
            int covered = this.getCovered();
            int count = this.getSize();
            for (Probe probe : this.probes) {
                probe.run(result, coverageDescription);
            }
            if (this.displayStatistics && covered != count) {
                String msg = "Coverage Test failed: Only " + covered + " of " + count + " probes covered.";
                result.fireTestFailure(new Failure(coverageDescription, (Throwable)new AssertionFailedError(msg)));
            }
        } else {
            String msg = "Coverage Failure: No coverage test performed, because test failed.";
            result.fireTestFailure(new Failure(coverageDescription, (Throwable)new AssertionFailedError(msg)));
        }
        this.clear();
    }

    public static void setProbeTable(ProbeTable pt) {
        table = pt;
    }

    public static ProbeTable getProbeTable() {
        return table;
    }

    public void clear() {
        this.probes.clear();
    }

    public int getSize() {
        return this.probes.size();
    }

    public int getCovered() {
        int covered = 0;
        for (int i = 0; i < this.probes.size(); ++i) {
            Probe probe = this.probes.get(i);
            if (probe.coverageFailure()) continue;
            ++covered;
        }
        return covered;
    }
}

