/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.util.List;
import java.util.Vector;
import org.hansel.HanselFrame;
import org.hansel.Probe;
import org.hansel.ProbeData;
import org.hansel.ProbeFactory;
import org.hansel.Util;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class HanselCodeAdapter
extends MethodAdapter {
    private boolean first;
    private int pos;
    private InsnList instructions;
    private String className;
    private String methodName;
    private HanselFrame[] frames;
    private List<Probe> probes;
    private List tryCatchBlocks;
    private Probe methodProbe;
    private int access;
    private ClassLoader loader;

    public HanselCodeAdapter(int access, String className, String methodName, InsnList instructions, List tryCatchBlocks, MethodVisitor mv, HanselFrame[] frames, ClassLoader loader) {
        super(mv);
        this.access = access;
        this.first = true;
        this.pos = 0;
        this.instructions = instructions;
        this.className = className;
        this.methodName = methodName;
        this.frames = frames;
        this.probes = new Vector<Probe>();
        this.tryCatchBlocks = tryCatchBlocks;
        this.loader = loader;
    }

    private void addProbe(Probe probe) {
        probe.insertProbeCode(this.mv);
        this.probes.add(probe);
    }

    private void checkFirst() {
        ++this.pos;
        if (!this.first) {
            return;
        }
        this.first = false;
        if (!this.isEmptyPrivateConstructor() && !this.isStaticConstructor()) {
            this.methodProbe = ProbeFactory.createMethodProbe(this.getProbeData());
            this.addProbe(this.methodProbe);
        }
    }

    private boolean isEmptyPrivateConstructor() {
        return "<init>".equals(this.methodName) && (this.access & 2) > 0 && this.countRelevantInstructions(this.instructions) == 3;
    }

    private int countRelevantInstructions(InsnList instructions) {
        int count = 0;
        for (AbstractInsnNode node : instructions.toArray()) {
            if (node instanceof LineNumberNode || node instanceof LabelNode) continue;
            ++count;
        }
        return count;
    }

    private boolean isStaticConstructor() {
        return "<clinit>".equals(this.methodName);
    }

    private ProbeData getProbeData() {
        return new ProbeData(this.className, this.methodName, this.frames[this.pos - 1], this.pos, this.instructions.size(), this.loader);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.checkFirst();
        int startIndex = Util.findIndex(this.instructions, start);
        for (int i = 0; i < this.probes.size(); ++i) {
            ProbeData pd = this.probes.get(i).getProbeData();
            if (startIndex >= pd.getPosition()) continue;
            pd.setLineNumber(line);
        }
    }

    public void visitInsn(int opcode) {
        this.checkFirst();
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkFirst();
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.checkFirst();
        this.mv.visitVarInsn(opcode, var);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.checkFirst();
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.checkFirst();
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.checkFirst();
        if (opcode != 167) {
            this.addProbe(ProbeFactory.createBranchProbe(this.getProbeData(), opcode));
        }
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        ++this.pos;
        this.mv.visitLabel(label);
        if (this.isExceptionHandler(label) && !this.isMonitorExitHandler()) {
            this.addProbe(ProbeFactory.createExceptionProbe(this.getProbeData(), this.methodProbe));
        }
    }

    private boolean isMonitorExitHandler() {
        if (this.instructions.size() < this.pos + 6) {
            return false;
        }
        if (!this.isOpcode(this.pos, 58)) {
            return false;
        }
        if (!this.isOpcode(this.pos + 1, 25)) {
            return false;
        }
        if (!this.isOpcode(this.pos + 2, 195)) {
            return false;
        }
        if (!this.isLabel(this.pos + 3)) {
            return false;
        }
        if (!this.isOpcode(this.pos + 4, 25)) {
            return false;
        }
        return this.isOpcode(this.pos + 5, 191);
    }

    private boolean isLabel(int pos) {
        return this.instructions.get(pos) instanceof LabelNode;
    }

    private boolean isOpcode(int pos, int opcode) {
        return this.instructions.get(pos) instanceof AbstractInsnNode && this.instructions.get(pos).getOpcode() == opcode;
    }

    private boolean isExceptionHandler(Label l) {
        for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
            if (tryCatchBlockNode.handler.getLabel() != l || tryCatchBlockNode.type == null) continue;
            return true;
        }
        return false;
    }

    public void visitLdcInsn(Object cst) {
        this.checkFirst();
        this.mv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.checkFirst();
        this.mv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.checkFirst();
        this.addProbe(ProbeFactory.createSelectProbe(this.getProbeData(), min, max, dflt, labels));
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkFirst();
        this.addProbe(ProbeFactory.createSelectProbe(this.getProbeData(), dflt, keys, labels));
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkFirst();
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitTypeInsn(int param, String str) {
        this.checkFirst();
        super.visitTypeInsn(param, str);
    }

    public void visitAttribute(Attribute attribute) {
        this.checkFirst();
        super.visitAttribute(attribute);
    }

    public void visitMaxs(int param, int param1) {
        super.visitMaxs(param, param1);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.checkFirst();
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.pos != this.frames.length) {
            throw new IllegalStateException("Inconsistent instrumentation: " + this.pos + " != " + this.frames.length);
        }
    }
}

