/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import org.hansel.CheckFailureRunListener;
import org.hansel.ProbeTable;
import org.hansel.Startup;
import org.junit.internal.runners.InitializationError;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageRunner
extends Suite {
    private ProbeTable probeTable = new ProbeTable(null);
    private Class[] coveredClasses;
    private Description desc;
    private Description coverageDesc;
    private boolean initialized;

    public CoverageRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.coveredClasses = CoverageRunner.getCoveredClasses(klass);
        this.initialized = false;
    }

    private static Class[] getCoveredClasses(Class<?> klass) throws InitializationError {
        CoverClasses annotation = klass.getAnnotation(CoverClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a CoverClasses annotation", klass.getName()));
        }
        return annotation.value();
    }

    private HashSet<String> toStringSet(Class[] classes) {
        HashSet<String> coveredClasses = new HashSet<String>();
        for (Class clazz : classes) {
            coveredClasses.add(clazz.getName());
        }
        return coveredClasses;
    }

    public void run(RunNotifier notifier) {
        this.init();
        CheckFailureRunListener listener = new CheckFailureRunListener();
        notifier.addListener((RunListener)listener);
        super.run(notifier);
        this.shutdown(notifier, listener.hasFailures());
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        try {
            ProbeTable.setProbeTable(this.probeTable);
            Startup.init(this.toStringSet(this.coveredClasses));
            this.initialized = true;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(RunNotifier result, boolean hasErrors) {
        try {
            this.loadClasses();
            Startup.tearDown();
            result.fireTestStarted(this.getCoverageDescription());
            this.probeTable.run(result, this.getCoverageDescription(), hasErrors);
        }
        catch (Exception e) {
            result.fireTestFailure(new Failure(this.getCoverageDescription(), (Throwable)e));
        }
        finally {
            result.fireTestFinished(this.getCoverageDescription());
        }
    }

    private void loadClasses() {
        for (Class clazz : this.coveredClasses) {
            clazz.getDeclaredFields();
        }
    }

    public Description getCoverageDescription() {
        if (this.coverageDesc == null) {
            this.coverageDesc = Description.createSuiteDescription((String)"Coverage");
        }
        return this.coverageDesc;
    }

    public Description getDescription() {
        this.init();
        if (this.desc == null) {
            this.desc = super.getDescription();
            this.desc.addChild(this.getCoverageDescription());
            try {
                this.probeTable.addProbeDescriptions(this.getCoverageDescription());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.desc;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CoverClasses {
        public Class[] value();
    }
}

