/*
 * Decompiled with CFR 0.152.
 */
package org.hansel;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.hansel.CoverageDecorator;
import org.hansel.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntCoverageTask
extends Task {
    private static final String SUITE_METHOD = "suite";
    private static final Class[] SUITE_TYPES = new Class[0];
    private static final Object[] SUITE_PARAMS = new Object[0];
    private static final FileFilter DIR_FILTER = new FileFilter(){

        public boolean accept(File path) {
            return path.isDirectory();
        }
    };
    private static final FilenameFilter CLASS_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".class") && name.indexOf("$") < 0;
        }
    };
    private String packages;
    private Path classpath;
    private String classFilePath;
    private String excludePackages;
    private boolean printStats = true;
    private ClassLoader cl;
    private ClassLoader oldCl;
    private int numTests = 0;
    private int numCoverageTests = 0;

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public Path createClasspath() {
        this.classpath = new Path(this.getProject());
        return this.classpath;
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setStats(boolean printStats) {
        this.printStats = printStats;
    }

    public void setClassFilePath(String classFilePath) {
        this.classFilePath = classFilePath;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public void setExcludePackages(String excludePackages) {
        this.excludePackages = excludePackages;
    }

    private void createClassloader() throws BuildException {
        Path path = new Path(this.getProject());
        path.setLocation(new File(this.classFilePath));
        if (this.classpath != null) {
            this.classpath.append(path);
        } else {
            this.classpath = path;
        }
        this.cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath, true);
        this.oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
    }

    private void resetClassLoader() {
        Thread.currentThread().setContextClassLoader(this.oldCl);
    }

    private Set createSortedSet() {
        return new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    private String normalize(String packageName) {
        while (packageName.endsWith("*")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        if (packageName.endsWith(File.separator)) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    private File getPackageFile(String packageName) throws BuildException {
        packageName = this.classFilePath + File.separator + packageName;
        return this.testDirectory("Package", packageName);
    }

    private void findClasses(String packageName, Set<Class> addTo) {
        File packageFile = this.getPackageFile(packageName);
        File[] classes = packageFile.listFiles(CLASS_FILTER);
        for (int i = 0; i < classes.length; ++i) {
            String name = classes[i].getName();
            String classname = packageName.replace(File.separatorChar, '.') + "." + name.substring(0, name.length() - 6);
            try {
                addTo.add(this.cl.loadClass(classname));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                throw new BuildException((Throwable)cnfe);
            }
        }
    }

    private Set<String> createPackageSet(String path, String packageNames) {
        HashSet<String> result = new HashSet<String>();
        if (packageNames == null) {
            return result;
        }
        packageNames = packageNames.replace('.', File.separatorChar);
        Stack<String> stack = new Stack<String>();
        StringTokenizer st = new StringTokenizer(packageNames, ",");
        while (st.hasMoreTokens()) {
            stack.push(st.nextToken().trim());
        }
        while (!stack.isEmpty()) {
            String packageName = (String)stack.pop();
            boolean recurse = packageName.endsWith("*");
            packageName = this.normalize(packageName);
            File packageFile = this.getPackageFile(packageName);
            result.add(packageName);
            if (!recurse) continue;
            File[] subdirs = packageFile.listFiles(DIR_FILTER);
            for (int i = 0; i < subdirs.length; ++i) {
                stack.push(packageName + File.separator + subdirs[i].getName() + "*");
            }
        }
        return result;
    }

    private Set getClasses(Set packages) {
        Set result = this.createSortedSet();
        for (String packageName : packages) {
            this.findClasses(packageName, result);
        }
        return result;
    }

    private void addTest(Set<String> testClasses, Set<Class> resultSet, Test test) throws ClassNotFoundException {
        String className = test.getClass().getName();
        if (testClasses.contains(className)) {
            return;
        }
        if (!className.startsWith(TestSuite.class.getName()) && !className.startsWith(CoverageDecorator.class.getName())) {
            ++this.numTests;
            testClasses.add(className);
        }
        if (test instanceof TestSuite) {
            Enumeration e = ((TestSuite)test).tests();
            while (e.hasMoreElements()) {
                this.addTest(testClasses, resultSet, (Test)e.nextElement());
            }
        }
        if (test instanceof CoverageDecorator) {
            ++this.numCoverageTests;
            Class[] classes = ((CoverageDecorator)test).getClassesCovered();
            for (int i = 0; i < classes.length; ++i) {
                resultSet.add(classes[i]);
            }
        }
    }

    private Set getClassesCovered(Set<String> classSet) throws ClassNotFoundException {
        Set result = this.createSortedSet();
        Iterator<String> it = classSet.iterator();
        while (it.hasNext()) {
            HashSet<String> testClasses = new HashSet<String>();
            Class next = (Class)((Object)it.next());
            if (next.isInterface() || (next.getModifiers() & 0x400) != 0 || !Test.class.isAssignableFrom(next)) continue;
            try {
                Method suitMethod = next.getMethod(SUITE_METHOD, SUITE_TYPES);
                try {
                    this.addTest(testClasses, result, (Test)suitMethod.invoke(null, SUITE_PARAMS));
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (NoSuchMethodException nsme) {
                Enumeration e = new TestSuite(next).tests();
                while (e.hasMoreElements()) {
                    this.addTest(testClasses, result, (Test)e.nextElement());
                }
            }
        }
        return result;
    }

    private Set getClassesToCover(Set<Class> classes) {
        Set result = this.createSortedSet();
        for (Class next : classes) {
            if (next.isInterface() || Test.class.isAssignableFrom(next)) continue;
            result.add(next);
        }
        return result;
    }

    private File testDirectory(String name, String path) throws BuildException {
        if (path == null) {
            throw new BuildException("'" + name + "' property has to be set.");
        }
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new BuildException(name + " directory: '" + path + "' does not exist.");
        }
        return dir;
    }

    public void execute() throws BuildException {
        try {
            this.testDirectory("ClassFilePath", this.classFilePath);
            this.createClassloader();
            Set<String> packageSet = this.createPackageSet(this.classFilePath, this.packages);
            Set<String> excludePackageSet = this.createPackageSet(this.classFilePath, this.excludePackages);
            Set allClasses = this.getClasses(packageSet);
            int numClasses = allClasses.size();
            Set classesCovered = this.getClassesCovered(allClasses);
            packageSet.removeAll(excludePackageSet);
            Set classes = this.getClasses(packageSet);
            Set classesToCover = this.getClassesToCover(classes);
            int numClassesToCover = classesToCover.size();
            classesToCover.removeAll(classesCovered);
            Iterator it = classesToCover.iterator();
            while (it.hasNext()) {
                this.handleErrorOutput("Class not covered by a coverage test: '" + ((Class)it.next()).getName() + "'");
            }
            int numUncoveredClasses = classesToCover.size();
            int numCoveredClasses = numClassesToCover - numUncoveredClasses;
            if (this.printStats) {
                this.handleOutput("");
                this.handleOutput("Coverage Statistics");
                this.handleOutput("--------------------");
                this.handleOutput("Classes:                    " + Util.leftFill(5, "" + numClasses));
                this.handleOutput("Classes requiring coverage: " + Util.leftFill(5, "" + numClassesToCover));
                this.handleOutput("Testcases:                  " + Util.leftFill(5, "" + this.numTests));
                this.handleOutput("Coverage Testcases:         " + Util.leftFill(5, "" + this.numCoverageTests));
                this.handleOutput("Classes covered:            " + Util.leftFill(5, "" + numCoveredClasses));
                NumberFormat nf = NumberFormat.getPercentInstance();
                String p = nf.format((double)numCoveredClasses / (double)numClassesToCover);
                this.handleOutput("Percentage covered:          " + Util.leftFill(5, p));
            }
            this.resetClassLoader();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
    }
}

