/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Subroutine;

public class Analyzer
implements Opcodes {
    private Interpreter interpreter;
    private int n;
    private InsnList insns;
    private List[] handlers;
    private Frame[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private boolean jsr;

    public Analyzer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Frame[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        int n;
        ArrayList<Object> arrayList;
        int n2;
        Object object;
        this.n = methodNode.instructions.size();
        this.insns = methodNode.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (int i = 0; i < methodNode.tryCatchBlocks.size(); ++i) {
            object = (TryCatchBlockNode)methodNode.tryCatchBlocks.get(i);
            int n3 = this.insns.indexOf(((TryCatchBlockNode)object).start);
            n2 = this.insns.indexOf(((TryCatchBlockNode)object).end);
            for (int j = n3; j < n2; ++j) {
                arrayList = this.handlers[j];
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    this.handlers[j] = arrayList;
                }
                arrayList.add(object);
            }
        }
        Frame frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        object = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
        n2 = 0;
        if ((methodNode.access & 8) == 0) {
            Type type = Type.getType("L" + string + ";");
            frame.setLocal(n2++, this.interpreter.newValue(type));
        }
        for (n = 0; n < typeArray.length; ++n) {
            frame.setLocal(n2++, this.interpreter.newValue(typeArray[n]));
            if (typeArray[n].getSize() != 2) continue;
            frame.setLocal(n2++, this.interpreter.newValue(null));
        }
        while (n2 < methodNode.maxLocals) {
            frame.setLocal(n2++, this.interpreter.newValue(null));
        }
        this.merge(0, frame, null);
        while (this.top > 0) {
            n = this.queue[--this.top];
            arrayList = this.frames[n];
            Subroutine subroutine = this.subroutines[n];
            this.queued[n] = false;
            try {
                Object object2;
                int n4;
                Object object3;
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(n);
                int n5 = abstractInsnNode.getOpcode();
                int n6 = abstractInsnNode.getType();
                this.jsr = false;
                if (n6 == 7 || n6 == 14 || n6 == 13) {
                    this.merge(n + 1, (Frame)((Object)arrayList), subroutine);
                    this.newControlFlowEdge(this.frames[n], this.frames[n + 1]);
                } else {
                    int n7;
                    frame.init((Frame)((Object)arrayList)).execute(abstractInsnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        object3 = (JumpInsnNode)abstractInsnNode;
                        if (n5 != 167 && n5 != 168) {
                            this.merge(n + 1, frame, subroutine);
                            this.newControlFlowEdge(this.frames[n], this.frames[n + 1]);
                        }
                        n4 = this.insns.indexOf(((JumpInsnNode)object3).label);
                        if (n5 == 168) {
                            this.jsr = true;
                            this.merge(n4, frame, new Subroutine(((JumpInsnNode)object3).label, methodNode.maxLocals, (JumpInsnNode)object3));
                        } else {
                            this.merge(n4, frame, subroutine);
                        }
                        this.newControlFlowEdge(this.frames[n], this.frames[n4]);
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object3 = (LookupSwitchInsnNode)abstractInsnNode;
                        n4 = this.insns.indexOf(((LookupSwitchInsnNode)object3).dflt);
                        this.merge(n4, frame, subroutine);
                        this.newControlFlowEdge(this.frames[n], this.frames[n4]);
                        for (n7 = 0; n7 < ((LookupSwitchInsnNode)object3).labels.size(); ++n7) {
                            object2 = (LabelNode)((LookupSwitchInsnNode)object3).labels.get(n7);
                            n4 = this.insns.indexOf((AbstractInsnNode)object2);
                            this.merge(n4, frame, subroutine);
                            this.newControlFlowEdge(this.frames[n], this.frames[n4]);
                        }
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object3 = (TableSwitchInsnNode)abstractInsnNode;
                        n4 = this.insns.indexOf(((TableSwitchInsnNode)object3).dflt);
                        this.merge(n4, frame, subroutine);
                        this.newControlFlowEdge(this.frames[n], this.frames[n4]);
                        for (n7 = 0; n7 < ((TableSwitchInsnNode)object3).labels.size(); ++n7) {
                            object2 = (LabelNode)((TableSwitchInsnNode)object3).labels.get(n7);
                            n4 = this.insns.indexOf((AbstractInsnNode)object2);
                            this.merge(n4, frame, subroutine);
                            this.newControlFlowEdge(this.frames[n], this.frames[n4]);
                        }
                    } else if (n5 == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException("RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine.callers.size(); ++i) {
                            Object e = subroutine.callers.get(i);
                            n7 = this.insns.indexOf((AbstractInsnNode)e);
                            this.merge(n7 + 1, this.frames[n7], frame, this.subroutines[n7], subroutine.access);
                            this.newControlFlowEdge(this.frames[n], this.frames[n7 + 1]);
                        }
                    } else if (n5 != 191 && (n5 < 172 || n5 > 177)) {
                        if (subroutine != null) {
                            if (abstractInsnNode instanceof VarInsnNode) {
                                int n8 = ((VarInsnNode)abstractInsnNode).var;
                                subroutine.access[n8] = true;
                                if (n5 == 22 || n5 == 24 || n5 == 55 || n5 == 57) {
                                    subroutine.access[n8 + 1] = true;
                                }
                            } else if (abstractInsnNode instanceof IincInsnNode) {
                                int n9 = ((IincInsnNode)abstractInsnNode).var;
                                subroutine.access[n9] = true;
                            }
                        }
                        this.merge(n + 1, frame, subroutine);
                        this.newControlFlowEdge(this.frames[n], this.frames[n + 1]);
                    }
                }
                if ((object3 = this.handlers[n]) == null) continue;
                for (n4 = 0; n4 < object3.size(); ++n4) {
                    TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)object3.get(n4);
                    object2 = tryCatchBlockNode.type == null ? Type.getType("Ljava/lang/Throwable;") : Type.getType("L" + tryCatchBlockNode.type + ";");
                    ((Frame)object).init((Frame)((Object)arrayList));
                    ((Frame)object).clearStack();
                    ((Frame)object).push(this.interpreter.newValue((Type)object2));
                    int n10 = this.insns.indexOf(tryCatchBlockNode.handler);
                    this.merge(n10, (Frame)object, subroutine);
                    this.newControlFlowExceptionEdge(this.frames[n], this.frames[n10]);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException("Error at instruction " + n + ": " + analyzerException.getMessage(), analyzerException);
            }
            catch (Exception exception) {
                throw new AnalyzerException("Error at instruction " + n + ": " + exception.getMessage(), exception);
            }
        }
        return this.frames;
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    public List getHandlers(int n) {
        return this.handlers[n];
    }

    protected Frame newFrame(int n, int n2) {
        return new Frame(n, n2);
    }

    protected Frame newFrame(Frame frame) {
        return new Frame(frame);
    }

    protected void newControlFlowEdge(Frame frame, Frame frame2) {
    }

    protected void newControlFlowExceptionEdge(Frame frame, Frame frame2) {
    }

    private void merge(int n, Frame frame, Subroutine subroutine) throws AnalyzerException {
        if (n > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame frame2 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        boolean bl = false;
        if (frame2 == null) {
            this.frames[n] = this.newFrame(frame);
            bl = true;
        } else {
            bl |= frame2.merge(frame, this.interpreter);
        }
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = subroutine.copy();
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine, !this.jsr);
        }
        if (bl && !this.queued[n]) {
            this.queued[n] = true;
            this.queue[this.top++] = n;
        }
    }

    private void merge(int n, Frame frame, Frame frame2, Subroutine subroutine, boolean[] blArray) throws AnalyzerException {
        if (n > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame frame3 = this.frames[n];
        Subroutine subroutine2 = this.subroutines[n];
        boolean bl = false;
        frame2.merge(frame, blArray);
        if (frame3 == null) {
            this.frames[n] = this.newFrame(frame2);
            bl = true;
        } else {
            bl |= frame3.merge(frame2, blArray);
        }
        if (subroutine2 == null) {
            if (subroutine != null) {
                this.subroutines[n] = subroutine.copy();
                bl = true;
            }
        } else if (subroutine != null) {
            bl |= subroutine2.merge(subroutine, !this.jsr);
        }
        if (bl && !this.queued[n]) {
            this.queued[n] = true;
            this.queue[this.top++] = n;
        }
    }
}

