/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import java.util.Hashtable;

class Condition {
    private String condition;

    private Condition() {
    }

    private static Hashtable createConditionTable() {
        Hashtable<String, String> conditionTable = new Hashtable<String, String>(34);
        conditionTable.put("-", "light");
        conditionTable.put("+", "heavy");
        conditionTable.put("VC", "in vicinity: ");
        conditionTable.put("MI", "shallow");
        conditionTable.put("BC", "patches");
        conditionTable.put("SH", "showers");
        conditionTable.put("PR", "partial");
        conditionTable.put("TS", "thunderstorm");
        conditionTable.put("BL", "blowing");
        conditionTable.put("DR", "drifting");
        conditionTable.put("FZ", "freezing");
        conditionTable.put("DZ", "drizzle");
        conditionTable.put("RA", "rain");
        conditionTable.put("SN", "snow");
        conditionTable.put("SG", "snow grains");
        conditionTable.put("IC", "ice crystals");
        conditionTable.put("PL", "ice pellets");
        conditionTable.put("GR", "hail");
        conditionTable.put("GS", "small hail/snow pellets");
        conditionTable.put("UP", "unknown precipitation");
        conditionTable.put("BR", "mist");
        conditionTable.put("FG", "fog");
        conditionTable.put("FU", "smoke");
        conditionTable.put("VA", "volcanic ash");
        conditionTable.put("SA", "sand");
        conditionTable.put("HZ", "haze");
        conditionTable.put("PY", "spray");
        conditionTable.put("DU", "widespread dust");
        conditionTable.put("SQ", "squall");
        conditionTable.put("SS", "sandstorm");
        conditionTable.put("DS", "duststorm");
        conditionTable.put("PO", "well developed dust/sand whirls");
        conditionTable.put("FC", "funnel cloud");
        conditionTable.put("+FC", "tornado/waterspout");
        return conditionTable;
    }

    public static boolean isACondition(String metarString) {
        if (metarString == null) {
            return false;
        }
        char[] buf = metarString.toCharArray();
        Hashtable conditionTable = Condition.createConditionTable();
        int i = 0;
        if (buf.length < 2 || buf.length > 8) {
            return false;
        }
        if (!(buf[i] != '-' && buf[i] != '+' || metarString.startsWith("+FC"))) {
            ++i;
        }
        while (i + 2 <= buf.length) {
            boolean found = false;
            if (conditionTable.containsKey(metarString.substring(i, i + 2))) {
                found = true;
                i += 2;
            }
            if (i + 3 <= buf.length && metarString.substring(i, i + 3).equals("+FC")) {
                found = true;
                i += 3;
            }
            if (found) continue;
        }
        return i == buf.length;
    }

    public static Condition parseCondition(String metarString) {
        if (!Condition.isACondition(metarString)) {
            return null;
        }
        Condition condition = new Condition();
        char[] buf = metarString.toCharArray();
        Hashtable conditionTable = Condition.createConditionTable();
        StringBuffer conditionString = new StringBuffer();
        int i = 0;
        if (!(buf[i] != '-' && buf[i] != '+' || metarString.startsWith("+FC"))) {
            conditionString.append(new String(buf, 0, 1));
            ++i;
        }
        while (i + 2 <= buf.length) {
            if (conditionTable.containsKey(metarString.substring(i, i + 2))) {
                conditionString.append(new String(buf, i, 2));
                i += 2;
            }
            if (i + 3 > buf.length || !metarString.substring(i, i + 3).equals("+FC")) continue;
            conditionString.append("+FC");
            i += 3;
        }
        condition.setCondition(conditionString.toString());
        return condition;
    }

    public boolean hasCondition(String needle) {
        if (needle == null) {
            return false;
        }
        if (this.condition == null) {
            return false;
        }
        return this.condition.indexOf(needle) >= 0;
    }

    public String getFormattedCondition() {
        if (this.condition == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        Hashtable conditionTable = Condition.createConditionTable();
        String conditionString = this.condition;
        while (conditionString.length() > 0) {
            if (conditionString.charAt(0) == '-' || conditionString.charAt(0) == '+') {
                s.append(conditionTable.get(conditionString.substring(0, 1)) + " ");
                conditionString = conditionString.substring(1);
                continue;
            }
            if (conditionString.startsWith("+FC")) {
                s.append(conditionTable.get(conditionString.substring(0, 3)) + " ");
                conditionString = conditionString.substring(3);
                continue;
            }
            if (conditionString.length() < 2) break;
            s.append(conditionTable.get(conditionString.substring(0, 2)) + " ");
            conditionString = conditionString.substring(2);
        }
        return s.toString().trim();
    }

    public String toString() {
        return this.condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}

