/*
 * Decompiled with CFR 0.152.
 */
package com.feldt.metar;

import com.feldt.metar.tools.Convert;

public class Altimeter {
    private Float altimeter;

    private Altimeter() {
    }

    public static boolean isAAltimeter(String metarString) {
        if (metarString == null) {
            return false;
        }
        if (metarString.length() != 5) {
            return false;
        }
        if (metarString.charAt(0) != 'A' && metarString.charAt(0) != 'Q') {
            return false;
        }
        for (int i = 1; i < 5; ++i) {
            if (Convert.isDigit(metarString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Altimeter parseAltimeter(String metarString) {
        if (!Altimeter.isAAltimeter(metarString)) {
            return null;
        }
        Altimeter altimeter = new Altimeter();
        char[] buf = metarString.toCharArray();
        if (buf[0] == 'A') {
            char[] fString = new char[]{buf[1], buf[2], '.', buf[3], buf[4]};
            altimeter.setAltimeter(new Float(new String(fString)));
        } else {
            altimeter.setAltimeter(new Float(Convert.hPaToInches(Float.parseFloat(metarString.substring(1)))));
        }
        return altimeter;
    }

    public String getFormattedAltimeter() {
        return this.altimeter + " in. Hg (" + (int)Convert.inchesToHPa(this.altimeter.floatValue()) + " hPa)";
    }

    public String toString() {
        return "A" + Integer.toString((int)(this.altimeter.floatValue() * 100.0f));
    }

    public Float getAltimeter() {
        return this.altimeter;
    }

    public void setAltimeter(Float altimeter) {
        this.altimeter = altimeter;
    }
}

