/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.util.proxy.PlainSocket;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

public class FTPPassiveDataSocket
implements FTPDataSocket {
    public static final String cvsId = "@(#)$Id: FTPPassiveDataSocket.java,v 1.6 2015/03/18 13:06:14 bruceb Exp $";
    protected StreamSocket sock = null;
    protected int port = 0;
    protected String remoteHost;
    protected int timeout = 0;

    public FTPPassiveDataSocket(String remoteHost, int port, int timeout) {
        this.remoteHost = remoteHost;
        this.port = port;
        this.timeout = timeout;
    }

    public void connect() throws IOException {
        this.sock = PlainSocket.createPlainSocket(this.remoteHost, this.port, this.timeout);
    }

    public void setTimeout(int millis) throws IOException {
        this.sock.setSoTimeout(millis);
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.sock.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws IOException {
        this.sock.setSendBufferSize(size);
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.sock.getInputStream();
    }

    public void close() throws IOException {
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public void closeChild() throws IOException {
    }
}

