/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.webhook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.webhook.IncomingWebhook;
import org.javacord.api.entity.webhook.Webhook;
import org.javacord.api.entity.webhook.internal.WebhookUpdaterDelegate;
import org.javacord.core.entity.webhook.WebhookImpl;
import org.javacord.core.util.FileContainer;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class WebhookUpdaterDelegateImpl
implements WebhookUpdaterDelegate {
    protected final Webhook webhook;
    private String reason = null;
    protected String name = null;
    protected ServerTextChannel channel = null;
    private FileContainer avatar = null;
    protected boolean updateAvatar = false;

    public WebhookUpdaterDelegateImpl(Webhook webhook) {
        this.webhook = webhook;
    }

    public void setAuditLogReason(String reason) {
        this.reason = reason;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChannel(ServerTextChannel channel) {
        this.channel = channel;
    }

    public void setAvatar(BufferedImage avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, "png");
        this.updateAvatar = true;
    }

    public void setAvatar(BufferedImage avatar, String fileType) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, fileType);
        this.updateAvatar = true;
    }

    public void setAvatar(File avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar);
        this.updateAvatar = true;
    }

    public void setAvatar(Icon avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar);
        this.updateAvatar = true;
    }

    public void setAvatar(URL avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar);
        this.updateAvatar = true;
    }

    public void setAvatar(byte[] avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, "png");
        this.updateAvatar = true;
    }

    public void setAvatar(byte[] avatar, String fileType) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, fileType);
        this.updateAvatar = true;
    }

    public void setAvatar(InputStream avatar) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, "png");
        this.updateAvatar = true;
    }

    public void setAvatar(InputStream avatar, String fileType) {
        this.avatar = avatar == null ? null : new FileContainer(avatar, fileType);
        this.updateAvatar = true;
    }

    public void removeAvatar() {
        this.avatar = null;
        this.updateAvatar = true;
    }

    private RestRequest<Webhook> setUrlParameters(RestRequest<Webhook> request) {
        Optional<String> token;
        if (this.channel == null && (token = this.webhook.asIncomingWebhook().map(IncomingWebhook::getToken)).isPresent()) {
            return request.setUrlParameters(this.webhook.getIdAsString(), token.get());
        }
        return request.setUrlParameters(this.webhook.getIdAsString());
    }

    public CompletableFuture<Webhook> update() {
        boolean patchWebhook = false;
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (this.name != null) {
            body.put("name", this.name);
            patchWebhook = true;
        }
        if (this.channel != null) {
            body.put("channel_id", this.channel.getIdAsString());
            patchWebhook = true;
        }
        if (this.updateAvatar) {
            if (this.avatar == null) {
                body.putNull("avatar");
            }
            patchWebhook = true;
        }
        if (patchWebhook) {
            if (this.avatar != null) {
                return ((CompletableFuture)this.avatar.asByteArray(this.webhook.getApi()).thenAccept(bytes -> {
                    String base64Avatar = "data:image/" + this.avatar.getFileType() + ";base64," + Base64.getEncoder().encodeToString((byte[])bytes);
                    body.put("avatar", base64Avatar);
                })).thenCompose(aVoid -> this.setUrlParameters(new RestRequest<Webhook>(this.webhook.getApi(), RestMethod.PATCH, RestEndpoint.WEBHOOK)).setBody((JsonNode)body).setAuditLogReason(this.reason).execute(result -> WebhookImpl.createWebhook(this.webhook.getApi(), result.getJsonBody())));
            }
            return this.setUrlParameters(new RestRequest<Webhook>(this.webhook.getApi(), RestMethod.PATCH, RestEndpoint.WEBHOOK)).setBody((JsonNode)body).setAuditLogReason(this.reason).execute(result -> WebhookImpl.createWebhook(this.webhook.getApi(), result.getJsonBody()));
        }
        return CompletableFuture.completedFuture(this.webhook);
    }
}

