/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message.component.internal;

import java.util.Optional;
import org.javacord.api.entity.message.component.ComponentType;
import org.javacord.api.entity.message.component.TextInput;
import org.javacord.api.entity.message.component.TextInputStyle;
import org.javacord.api.entity.message.component.internal.TextInputBuilderDelegate;
import org.javacord.core.entity.message.component.TextInputImpl;

public class TextInputBuilderDelegateImpl
implements TextInputBuilderDelegate {
    private final ComponentType type = ComponentType.TEXT_INPUT;
    private TextInputStyle style = null;
    private String customId = null;
    private String label = null;
    private String value = "";
    private String placeholder = null;
    private Integer minimumLength = null;
    private Integer maximumLength = null;
    private boolean required = false;

    public ComponentType getType() {
        return this.type;
    }

    public void copy(TextInput textInput) {
        this.style = textInput.getStyle().orElse(null);
        this.customId = textInput.getCustomId();
        this.label = textInput.getLabel().orElse(null);
        this.required = textInput.isRequired();
        this.minimumLength = textInput.getMinimumLength().orElse(null);
        this.maximumLength = textInput.getMaximumLength().orElse(null);
    }

    public void setStyle(TextInputStyle style) {
        this.style = style;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setValue(String value) {
        this.value = value == null ? "" : value;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setMinimumLength(Integer minimumLength) {
        this.minimumLength = minimumLength;
    }

    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public TextInputStyle getStyle() {
        return this.style;
    }

    public String getCustomId() {
        return this.customId;
    }

    public String getLabel() {
        return this.label;
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<String> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    public Optional<Integer> getMinimumLength() {
        return Optional.ofNullable(this.minimumLength);
    }

    public Optional<Integer> getMaximumLength() {
        return Optional.ofNullable(this.maximumLength);
    }

    public boolean isRequired() {
        return this.required;
    }

    public TextInput build() {
        return new TextInputImpl(this.style, this.label, this.customId, this.value, this.placeholder, this.required, this.minimumLength, this.maximumLength);
    }
}

