/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message.component.internal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.message.component.ComponentType;
import org.javacord.api.entity.message.component.SelectMenu;
import org.javacord.api.entity.message.component.SelectMenuOption;
import org.javacord.api.entity.message.component.internal.SelectMenuBuilderDelegate;
import org.javacord.core.entity.message.component.SelectMenuImpl;

public class SelectMenuBuilderDelegateImpl
implements SelectMenuBuilderDelegate {
    private ComponentType type = null;
    private List<SelectMenuOption> options = new ArrayList<SelectMenuOption>();
    private EnumSet<ChannelType> channelTypes = EnumSet.noneOf(ChannelType.class);
    private String placeholder = null;
    private int minimumValues = 1;
    private int maximumValues = 1;
    private String customId = null;
    private boolean isDisabled = false;

    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public void copy(SelectMenu selectMenu) {
        Optional placeholder = selectMenu.getPlaceholder();
        this.customId = selectMenu.getCustomId();
        this.minimumValues = selectMenu.getMinimumValues();
        this.maximumValues = selectMenu.getMaximumValues();
        this.isDisabled = selectMenu.isDisabled();
        this.options = selectMenu.getOptions();
        this.channelTypes = selectMenu.getChannelTypes();
        this.type = selectMenu.getType();
        placeholder.ifPresent(this::setPlaceholder);
    }

    public void addChannelType(ChannelType channelType) {
        this.channelTypes.add(channelType);
    }

    public void addOption(SelectMenuOption selectMenuOption) {
        this.options.add(selectMenuOption);
    }

    public void removeOption(SelectMenuOption selectMenuOption) {
        this.options.remove(selectMenuOption);
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public void setMinimumValues(int minimumValues) {
        this.minimumValues = minimumValues;
    }

    public void setMaximumValues(int maximumValues) {
        this.maximumValues = maximumValues;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public SelectMenu build() {
        return new SelectMenuImpl(this.type, this.options, this.placeholder, this.customId, this.minimumValues, this.maximumValues, this.isDisabled, this.channelTypes);
    }

    public void removeAllOptions() {
        this.options.clear();
    }

    public String getCustomId() {
        return this.customId;
    }
}

