/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.util;

public class HexaUtil {
    private static final String HEXA_DIGITS = "0123456789abcdef";

    public static final byte[] stringToByteArray(String orig) {
        String txt = orig.toLowerCase();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.charAt(i) == ' ') continue;
            sb.append(txt.charAt(i));
        }
        String packed = sb.toString();
        if (packed.length() % 2 != 0) {
            throw new RuntimeException("Must have even number of hexadigits, but has " + packed.length() + ".");
        }
        byte[] result = new byte[packed.length() / 2];
        for (int i = 0; i < packed.length(); i += 2) {
            int left = HexaUtil.hexaToDecimal(packed.charAt(i));
            int right = HexaUtil.hexaToDecimal(packed.charAt(i + 1));
            int total = left * 16 + right;
            result[i / 2] = total < 128 ? (byte)total : (byte)(total - 256);
        }
        return result;
    }

    public static final String byteArrayToString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] >= 0 ? b[i] : b[i] + 256;
            int left = v / 16;
            int right = v % 16;
            sb.append(HexaUtil.decimalToHexa(left));
            sb.append(HexaUtil.decimalToHexa(right));
        }
        return sb.toString();
    }

    private static char decimalToHexa(int d) {
        return HEXA_DIGITS.charAt(d);
    }

    private static int hexaToDecimal(char c) {
        for (int i = 0; i < HEXA_DIGITS.length(); ++i) {
            if (c != HEXA_DIGITS.charAt(i)) continue;
            return i;
        }
        throw new RuntimeException("Invalid hexa digit '" + c + "'.");
    }
}

