/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractPointShape;
import org.nocrala.tools.gis.data.esri.shapefile.util.ISUtil;

public class PointZShape
extends AbstractPointShape {
    private static final int FIXED_CONTENT_LENGTH = 18;
    private double z;
    private double m;

    public PointZShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        if (!rules.isAllowBadContentLength() && this.header.getContentLength() != 18) {
            throw new InvalidShapeFileException("Invalid PointZ shape header's content length. Expected 18 16-bit words but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
        }
        this.z = ISUtil.readLeDouble(is);
        this.m = ISUtil.readLeDouble(is);
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }
}

