/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractMultiPointShape;

public class MultiPointPlainShape
extends AbstractMultiPointShape {
    private static final int BASE_CONTENT_LENGTH = 20;

    public MultiPointPlainShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        if (!rules.isAllowBadContentLength()) {
            int expectedLength = 20 + this.numberOfPoints * 16 / 2;
            if (this.header.getContentLength() != expectedLength) {
                throw new InvalidShapeFileException("Invalid " + this.getShapeTypeName() + " shape header's content length. " + "Expected " + expectedLength + " 16-bit words (for " + this.numberOfPoints + " points)" + " but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
            }
        }
    }

    protected String getShapeTypeName() {
        return "MultiPoint";
    }
}

