/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractMultiPointShape;
import org.nocrala.tools.gis.data.esri.shapefile.util.ISUtil;

public class MultiPointMShape
extends AbstractMultiPointShape {
    private static final int BASE_CONTENT_LENGTH = 28;
    private double minM;
    private double maxM;
    private double[] m;

    public MultiPointMShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        if (!rules.isAllowBadContentLength()) {
            int expectedLength = 28 + this.numberOfPoints * 24 / 2;
            if (this.header.getContentLength() != expectedLength) {
                throw new InvalidShapeFileException("Invalid " + this.getShapeTypeName() + " shape header's content length. " + "Expected " + expectedLength + " 16-bit words (for " + this.numberOfPoints + " points)" + " but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
            }
        }
        this.minM = ISUtil.readLeDouble(is);
        this.maxM = ISUtil.readLeDouble(is);
        this.m = new double[this.numberOfPoints];
        for (int i = 0; i < this.numberOfPoints; ++i) {
            this.m[i] = ISUtil.readLeDouble(is);
        }
    }

    protected String getShapeTypeName() {
        return "MultiPointM";
    }

    public double getMinM() {
        return this.minM;
    }

    public double getMaxM() {
        return this.maxM;
    }

    public double[] getM() {
        return this.m;
    }
}

