/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractPolyShape;

public abstract class AbstractPolyPlainShape
extends AbstractPolyShape {
    private static final int BASE_CONTENT_LENGTH = 22;

    public AbstractPolyPlainShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        if (!rules.isAllowBadContentLength()) {
            int expectedLength = 22 + this.numberOfParts * 4 / 2 + this.numberOfPoints * 16 / 2;
            if (this.header.getContentLength() != expectedLength) {
                throw new InvalidShapeFileException("Invalid " + this.getShapeTypeName() + " shape header's content length. " + "Expected " + expectedLength + " 16-bit words (for " + this.numberOfParts + " parts and " + this.numberOfPoints + " points)" + " but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
            }
        }
    }
}

