/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.tomcat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gvagroup.tomcat.AbstractLifecycleListener;

public class MySQLThreadUnloader
extends AbstractLifecycleListener {
    private static final Logger log = LogManager.getLogger(MySQLThreadUnloader.class);

    @Override
    void onStartup(boolean isAfter) {
    }

    @Override
    void onShutdown(boolean isAfter) {
        if (isAfter) {
            return;
        }
        log.info("Shutting down MySQL abandoned connection thread");
        try {
            Class<?> c = Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
            Method m = c.getMethod("checkedShutdown", new Class[0]);
            m.invoke(null, new Object[0]);
            log.info("checkedShutdown()");
            Field f = c.getDeclaredField("threadRef");
            boolean oldAccess = f.canAccess(null);
            f.setAccessible(true);
            Object o = f.get(null);
            f.setAccessible(oldAccess);
            if (o != null) {
                int totalTime;
                Thread t = (Thread)o;
                for (totalTime = 0; t.isAlive() && totalTime < 250; totalTime += 50) {
                    Thread.sleep(50L);
                }
                if (t.isAlive()) {
                    m = c.getMethod("uncheckedShutdown", new Class[0]);
                    m.invoke(null, new Object[0]);
                    log.warn("uncheckedShutdown()");
                    while (t.isAlive() && totalTime < 1000) {
                        Thread.sleep(50L);
                        totalTime += 50;
                    }
                    if (t.isAlive()) {
                        throw new IllegalStateException("Thread alive after uncheckedShutdown()");
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("Cannot load class com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
        }
        catch (Exception e) {
            log.error(e.getClass().getSimpleName() + " shutting down thread - " + e.getMessage());
        }
    }
}

