/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.gvagroup.pool.StackTrace;
import org.gvagroup.pool.StackUtils;

class PreparedStatementWrapper
implements PreparedStatement {
    private final PreparedStatement _s;
    private boolean _isClosed;

    PreparedStatementWrapper(PreparedStatement s) {
        this._s = s;
    }

    public String toString() {
        return String.valueOf(this._s);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._s.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._s.isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this._s.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this._s.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this._isClosed) {
            StackTrace st = StackUtils.generate(true);
            System.err.println("Already Closed statement");
            st.printStackTrace(System.err);
        }
        try {
            this._s.close();
        }
        finally {
            this._isClosed = true;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._s.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this._s.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._s.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._s.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._s.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._s.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this._s.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this._s.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._s.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._s.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this._s.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this._s.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._s.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._s.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._s.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._s.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._s.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._s.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._s.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._s.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._s.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this._s.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._s.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this._s.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._s.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this._s.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._s.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this._s.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this._s.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this._s.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this._s.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this._s.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this._s.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._s.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this._s.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._s.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this._s.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this._s.isCloseOnCompletion();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this._s.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this._s.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this._s.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this._s.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this._s.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this._s.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this._s.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this._s.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this._s.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this._s.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this._s.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this._s.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this._s.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this._s.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this._s.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this._s.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._s.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._s.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._s.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this._s.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this._s.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this._s.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this._s.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this._s.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this._s.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this._s.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this._s.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this._s.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this._s.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._s.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this._s.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this._s.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this._s.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this._s.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this._s.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._s.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this._s.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this._s.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this._s.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this._s.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._s.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this._s.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this._s.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this._s.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this._s.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._s.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this._s.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this._s.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this._s.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this._s.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this._s.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this._s.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this._s.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int idx, InputStream is) throws SQLException {
        this._s.setBlob(idx, is);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this._s.setNClob(parameterIndex, reader);
    }
}

