/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.util.Map;
import java.util.Properties;
import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.JedisDomainSocketFactory;
import org.gvagroup.pool.JedisWrapper;
import org.gvagroup.pool.Recycler;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;

public class JedisPoolEntry
extends ConnectionPoolEntry<Jedis> {
    private static final long serialVersionUID = -8922331133236192374L;
    private final Properties _props = new Properties();

    public JedisPoolEntry(int id, Recycler<Jedis> src, Properties props) {
        super(id, src, JedisPoolEntry.class);
        this._props.putAll((Map<?, ?>)props);
    }

    @Override
    public String getType() {
        return "Jedis";
    }

    @Override
    void connect() throws Exception {
        String host = this._props.getProperty("addr", "locahost");
        if (host.startsWith("/")) {
            this.log.info("Using Unix socket {}", (Object)host);
            JedisDomainSocketFactory sf = new JedisDomainSocketFactory(host);
            this.setWrapper(new JedisWrapper(sf, new DefaultJedisConfig(), (ConnectionPoolEntry<Jedis>)this));
        } else {
            int port = Integer.parseInt(this._props.getProperty("port", "6379"));
            this.setWrapper(new JedisWrapper(host, port, (ConnectionPoolEntry<Jedis>)this));
        }
        Jedis j = (Jedis)this.get();
        j.select(Integer.parseInt(this._props.getProperty("db", "0")));
        j.clientSetname(String.format("%s-%d", this._props.getProperty("poolName", "jedis"), this.getID()));
        this.markConnected();
    }

    @Override
    Jedis reserve(boolean logStack) {
        this.checkState();
        this.markUsed();
        if (logStack) {
            this.generateStackTrace();
        }
        return (Jedis)this.getWrapper().get();
    }

    @Override
    void free() {
        if (!this.checkFree()) {
            this.markFree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean checkConnection() {
        this.markUsed();
        this.markChecked();
        try {
            Jedis j = (Jedis)this.get();
            String result = j.ping();
            boolean bl = "PONG".equals(result);
            return bl;
        }
        catch (Exception e) {
            this.log.error("Error checking {}-{} - {}", (Object)this.getType(), (Object)this.getID(), (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.markFree();
        }
    }

    @Override
    void cleanup() {
        Jedis j = (Jedis)this.get();
        j.resetState();
    }

    private static class DefaultJedisConfig
    implements JedisClientConfig {
        private DefaultJedisConfig() {
        }
    }
}

