/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.gvagroup.pool.ConnectionPool;
import org.gvagroup.pool.ConnectionPoolEntry;
import org.gvagroup.pool.JDBCPoolEntry;

public class JDBCPool
extends ConnectionPool<Connection> {
    private static final long serialVersionUID = 4958035033059527516L;
    private transient boolean _isMySQL;
    private boolean _autoCommit = true;

    @Override
    int getStaleTime() {
        return 145000;
    }

    public JDBCPool(int maxSize, String name) {
        super(maxSize, name, 60, JDBCPool.class);
        this.setWaitTime(20, 250);
        DriverManager.setLoginTimeout(2);
    }

    @Override
    public String getType() {
        return "JDBC";
    }

    public void setAutoCommit(boolean commit) {
        this._autoCommit = commit;
    }

    public void setURL(String url) {
        this._props.put("url", url);
    }

    public void setSocket(String socketFile) {
        if (socketFile == null) {
            return;
        }
        File f = new File(socketFile);
        if (f.exists() && this._isMySQL) {
            this._props.put("socketFactory", "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactoryCJ");
            this._props.put("junixsocket.file", f.getAbsolutePath());
        } else {
            this._props.remove("socketFactory");
            this._props.remove("junixsocket.file");
        }
    }

    public void setDriver(String driverClassName) throws ClassNotFoundException {
        Class<?> c = Class.forName(driverClassName);
        this._isMySQL = driverClassName.startsWith("com.mysql.cj.jdbc.");
        if (this._isMySQL) {
            this.log.info("MySQL JDBC Driver detected");
        }
        for (int x = 0; x < c.getInterfaces().length; ++x) {
            if (!c.getInterfaces()[x].getName().equals("java.sql.Driver")) continue;
            return;
        }
        throw new ClassCastException(String.format("%s does not implement java.sql.Driver", c.getName()));
    }

    @Override
    protected ConnectionPoolEntry<Connection> createConnection(int id) throws SQLException {
        String url = this._props.getProperty("junixsocket.file", this._props.getProperty("url"));
        this.log.info("{} connecting to {} as user {} ID #{}", (Object)this.getName(), (Object)url, (Object)this._props.getProperty("user"), (Object)id);
        JDBCPoolEntry entry = new JDBCPoolEntry(id, this, this._props);
        entry.setAutoCommit(this._autoCommit);
        entry.connect();
        return entry;
    }

    @Override
    public void close() {
        super.close();
        if (this._isMySQL) {
            this.log.info("Shutting down MySQL abandoned connection thread");
            try {
                Class<?> c = Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
                Method m = c.getMethod("uncheckedShutdown", new Class[0]);
                m.invoke(null, new Object[0]);
                Thread.sleep(250L);
                Field f = c.getDeclaredField("threadRef");
                boolean oldAccess = f.canAccess(null);
                f.setAccessible(true);
                Object o = f.get(null);
                f.setAccessible(oldAccess);
                if (o != null) {
                    Thread t = (Thread)o;
                    this.log.info("Found thread {} - {}", (Object)t.getName(), (Object)(t.isAlive() ? "Running" : "Terminated"));
                    for (int totalTime = 0; t.isAlive() && totalTime < 250; totalTime += 50) {
                        Thread.sleep(50L);
                    }
                    if (t.isAlive()) {
                        this.log.warn("{} still running", (Object)t.getName());
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.log.warn("Cannot load class com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
            }
            catch (Exception e) {
                this.log.error("{} shutting down thread - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }
}

