/*
 * Decompiled with CFR 0.152.
 */
package org.gvagroup.pool;

import java.io.Serializable;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gvagroup.pool.ConnectionWrapper;
import org.gvagroup.pool.Recycler;
import org.gvagroup.pool.StackTrace;
import org.gvagroup.pool.StackUtils;

public abstract class ConnectionPoolEntry<T extends AutoCloseable>
implements Serializable,
Comparable<ConnectionPoolEntry<T>> {
    private static final long serialVersionUID = 458103041409760160L;
    protected final transient Logger log;
    private transient ConnectionWrapper<T> _c;
    private transient Recycler<T> _src;
    private StackTrace _stackInfo;
    private final int _id;
    private volatile boolean _inUse = false;
    private boolean _dynamic = false;
    private boolean _connected = false;
    private long _lastThreadID;
    private String _lastThreadName;
    private long _totalTime;
    private long _useTime;
    private long _maxUseTime;
    private long _startTime;
    private long _lastUsed;
    private long _lastChecked;
    private int _connectCount;
    private int _checkCount;
    private long _useCount;
    private long _sessionUseCount;

    protected ConnectionPoolEntry(int id, Recycler<T> src, Class<? extends ConnectionPoolEntry<T>> logClass) {
        this._id = id;
        this._src = src;
        this.log = LogManager.getLogger(logClass);
    }

    public abstract String getType();

    public boolean inUse() {
        return this._inUse;
    }

    boolean isActive() {
        return this._c != null;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public boolean isConnected() {
        return this._c != null || this._connected;
    }

    abstract void connect() throws Exception;

    abstract void free();

    void close() {
        try {
            if (this.inUse()) {
                this.markFree();
            }
            this._c.forceClose();
        }
        catch (Exception exception) {
        }
        finally {
            this._connected = false;
            this._c = null;
        }
    }

    protected boolean checkFree() {
        boolean wasFree;
        boolean bl = wasFree = !this.inUse();
        if (wasFree) {
            this.log.warn("Attempting to re-free Connection {}", (Object)this._id);
        }
        return wasFree;
    }

    protected void markConnected() {
        ++this._connectCount;
    }

    protected void markFree() {
        this._useTime = this.getUseTime();
        this._totalTime += this._useTime;
        this._maxUseTime = Math.max(this._maxUseTime, this._useTime);
        this._lastThreadID = 0L;
        this._lastThreadName = null;
        this._inUse = false;
    }

    protected void markUsed() {
        this._inUse = true;
        this._startTime = System.nanoTime();
        this._lastUsed = System.currentTimeMillis();
        ++this._useCount;
        ++this._sessionUseCount;
        Thread t = Thread.currentThread();
        this._lastThreadID = t.threadId();
        this._lastThreadName = t.getName();
    }

    protected void markChecked() {
        ++this._checkCount;
        this._lastChecked = System.currentTimeMillis();
    }

    abstract boolean checkConnection();

    abstract void cleanup() throws Exception;

    void recycle() {
        this._src.release((AutoCloseable)((Object)this._c));
    }

    T get() {
        return this._c.get();
    }

    ConnectionWrapper<T> getWrapper() {
        return this._c;
    }

    protected void setWrapper(ConnectionWrapper<T> cw) {
        this._lastUsed = System.currentTimeMillis();
        this._connected = true;
        this._sessionUseCount = 0L;
        this._c = cw;
    }

    public int getID() {
        return this._id;
    }

    void setDynamic(boolean dynamic) {
        this._dynamic = dynamic;
    }

    protected void checkState() {
        if (this.inUse()) {
            throw new IllegalStateException(String.format("Connection %s already in use", this.toString()));
        }
        if (!this.isActive()) {
            throw new IllegalStateException(String.format("Connection %s inactive", this.toString()));
        }
    }

    protected void generateStackTrace() {
        try {
            this._stackInfo = StackUtils.generate(true);
        }
        catch (Exception e) {
            this.log.warn("Cannot fetch stack trace - {}", (Object)e.getMessage());
        }
    }

    abstract T reserve(boolean var1);

    public long getUseTime() {
        return this.inUse() ? System.nanoTime() - this._startTime : this._useTime;
    }

    public Duration getMaxUseTime() {
        return Duration.ofNanos(this._maxUseTime);
    }

    public int getConnectCount() {
        return this._connectCount;
    }

    public int getCheckCount() {
        return this._checkCount;
    }

    public long getUseCount() {
        return this._useCount;
    }

    public long getSessionUseCount() {
        return this._sessionUseCount;
    }

    public long getLastCheckTime() {
        return this._lastChecked;
    }

    public long getLastUseTime() {
        return this._lastUsed;
    }

    public Duration getTotalUseTime() {
        return Duration.ofNanos(this._totalTime);
    }

    public long getLastThreadID() {
        return this._lastThreadID;
    }

    public String getLastThreadName() {
        return this._lastThreadName;
    }

    public StackTrace getStackInfo() {
        return this._stackInfo;
    }

    public boolean equals(Object o2) {
        ConnectionPoolEntry cpe2;
        return o2 instanceof ConnectionPoolEntry && this.compareTo(cpe2 = (ConnectionPoolEntry)o2) == 0;
    }

    @Override
    public int compareTo(ConnectionPoolEntry<T> e2) {
        return Integer.compare(this._id, e2._id);
    }

    public int hashCode() {
        return this._id;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder("#").append(this._id);
        return buf.toString();
    }
}

